/*
 * Decompiled with CFR 0.152.
 */
package io.greptime;

import java.util.HashMap;
import java.util.Map;

public enum Status {
    Success(0),
    Unknown(1000),
    Unsupported(1001),
    Unexpected(1002),
    Internal(1003, true),
    InvalidArguments(1004),
    Cancelled(1005),
    InvalidSyntax(2000),
    PlanQuery(3000),
    EngineExecuteQuery(3001),
    TableAlreadyExists(4000),
    TableNotFound(4001),
    TableColumnNotFound(4002),
    TableColumnExists(4003),
    DatabaseNotFound(4004),
    RegionNotFound(4005),
    RegionAlreadyExists(4006),
    RegionReadonly(4007),
    StorageUnavailable(5000, true),
    RuntimeResourcesExhausted(6000, true),
    RateLimited(6001),
    UserNotFound(7000),
    UnsupportedPasswordType(7001),
    UserPasswordMismatch(7002),
    AuthHeaderNotFound(7003),
    InvalidAuthHeader(7004),
    AccessDenied(7005),
    PermissionDenied(7006);

    private static final Map<Integer, Status> DICT;
    private final int statusCode;
    private final boolean shouldRetry;

    private Status(int statusCode) {
        this(statusCode, false);
    }

    private Status(int statusCode, boolean shouldRetry) {
        this.statusCode = statusCode;
        this.shouldRetry = shouldRetry;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static boolean isSuccess(int statusCode) {
        return statusCode == Success.getStatusCode();
    }

    public boolean isShouldRetry() {
        return this.shouldRetry;
    }

    public static Status parse(int statusCode) {
        return DICT.get(statusCode);
    }

    static {
        DICT = new HashMap<Integer, Status>();
        for (Status s : Status.values()) {
            DICT.put(s.getStatusCode(), s);
        }
    }
}

