/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.util.Ensures;
import io.greptime.models.DataType;
import io.greptime.models.IntervalMonthDayNano;
import io.greptime.v1.Common;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;

public class ValueUtil {
    static int ONE_DAY_IN_SECONDS = 86400;

    static long getLongValue(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new IllegalArgumentException("Unsupported value type: " + value.getClass());
    }

    static int getDateValue(Object value) {
        if (value instanceof Instant) {
            long epochDay = ((Instant)value).getEpochSecond() / (long)ONE_DAY_IN_SECONDS;
            return (int)epochDay;
        }
        if (value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            long epochDay = instant.getEpochSecond() / (long)ONE_DAY_IN_SECONDS;
            return (int)epochDay;
        }
        if (value instanceof LocalDate) {
            return (int)((LocalDate)value).toEpochDay();
        }
        return (int)ValueUtil.getLongValue(value);
    }

    static long getDateTimeValue(Object value) {
        if (value instanceof Instant) {
            return ((Instant)value).toEpochMilli();
        }
        if (value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            return instant.toEpochMilli();
        }
        return ValueUtil.getLongValue(value);
    }

    static Common.IntervalMonthDayNano getIntervalMonthDayNanoValue(Object value) {
        Ensures.ensure((boolean)(value instanceof IntervalMonthDayNano), (String)"Expected type: `IntervalMonthDayNano`, actual: %s", (Object[])new Object[]{value.getClass()});
        return ((IntervalMonthDayNano)value).into();
    }

    static Common.Decimal128 getDecimal128Value(Common.ColumnDataTypeExtension dataTypeExtension, Object value) {
        Ensures.ensure((boolean)(value instanceof BigDecimal), (String)"Expected type: `BigDecimal`, actual: %s", (Object[])new Object[]{value.getClass()});
        Ensures.ensureNonNull((Object)dataTypeExtension, (String)"Null `dataTypeExtension`");
        Common.DecimalTypeExtension decimalTypeExtension = dataTypeExtension.hasDecimalType() ? dataTypeExtension.getDecimalType() : DataType.DecimalTypeExtension.DEFAULT.into();
        BigDecimal decimal = (BigDecimal)value;
        BigDecimal converted = decimal.setScale(decimalTypeExtension.getScale(), RoundingMode.HALF_UP);
        BigInteger unscaledValue = converted.unscaledValue();
        long high64Bits = unscaledValue.shiftRight(64).longValue();
        long low64Bits = unscaledValue.longValue();
        return Common.Decimal128.newBuilder().setHi(high64Bits).setLo(low64Bits).build();
    }
}

