package io.gridgo.boot.support.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Repeatable(Connectors.class)
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Connector {

    String value();

    String builder() default "";

    String incomingFormat() default "";

    String outgoingFormat() default "";

    String[] incomingTransformers() default {};

    String[] outgoingTransformers() default {};
}
