/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot;

import io.gridgo.boot.config.ResourceConfigurator;
import io.gridgo.boot.registry.AnnotatedRegistry;
import io.gridgo.boot.support.AnnotationScanner;
import io.gridgo.boot.support.FieldInjector;
import io.gridgo.boot.support.LazyInitializer;
import io.gridgo.boot.support.annotations.AnnotationUtils;
import io.gridgo.boot.support.annotations.ContextInitializer;
import io.gridgo.boot.support.annotations.EnableComponentScan;
import io.gridgo.boot.support.annotations.RegistryInitializer;
import io.gridgo.boot.support.exceptions.InitializationException;
import io.gridgo.boot.support.exceptions.ResourceNotFoundException;
import io.gridgo.boot.support.scanners.impl.ComponentScanner;
import io.gridgo.boot.support.scanners.impl.GatewayScanner;
import io.gridgo.config.Configurator;
import io.gridgo.core.GridgoContext;
import io.gridgo.core.impl.ConfiguratorContextBuilder;
import io.gridgo.core.impl.DefaultGridgoContextBuilder;
import io.gridgo.framework.impl.AbstractComponentLifecycle;
import io.gridgo.framework.support.Registry;
import io.gridgo.utils.ThreadUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridgoApplication
extends AbstractComponentLifecycle {
    private static final Logger log = LoggerFactory.getLogger(GridgoApplication.class);
    private GridgoContext context;
    private String appName;
    private Registry registry;
    private Class<?> applicationClass;
    private String[] args;
    private List<LazyInitializer> lazyInitializers = new ArrayList<LazyInitializer>();
    private FieldInjector injector;
    private List<AnnotationScanner> scanners = new ArrayList<AnnotationScanner>();

    private GridgoApplication(Class<?> applicationClass, String ... args) {
        this.applicationClass = applicationClass;
        this.args = args;
        this.registry = new AnnotatedRegistry(applicationClass);
        this.initializeRegistry();
        this.initializeContext();
        this.appName = this.context.getName();
        this.injector = new FieldInjector(this.context);
        this.initializeComponents();
        this.initializeContextWithAnnotation();
    }

    protected void initializeContext() {
        try {
            ResourceConfigurator configurator = new ResourceConfigurator();
            this.context = new ConfiguratorContextBuilder().setRegistry(this.registry).setConfigurator((Configurator)configurator).build();
        }
        catch (ResourceNotFoundException ex) {
            this.context = new DefaultGridgoContextBuilder().setRegistry(this.registry).build();
        }
    }

    protected void initializeComponents() {
        this.scanForComponents();
        this.injectLazyInitializers();
    }

    protected void scanForComponents() {
        EnableComponentScan enableComponentScan = this.applicationClass.getAnnotation(EnableComponentScan.class);
        if (enableComponentScan != null) {
            this.scanComponents();
        }
    }

    protected void injectLazyInitializers() {
        for (LazyInitializer initializer : this.lazyInitializers) {
            this.injector.injectFields(initializer.getGatewayClass(), initializer.getInstance());
        }
    }

    private void scanComponents() {
        String pkg = this.applicationClass.getPackageName();
        Reflections ref = new Reflections(pkg, new Scanner[0]);
        this.scanners.add(new GatewayScanner());
        this.scanners.add(new ComponentScanner());
        for (AnnotationScanner scanner : this.scanners) {
            scanner.scanAnnotation(ref, this.context, this.lazyInitializers);
        }
    }

    public static GridgoApplication run(Class<?> applicationClass, String ... args) {
        GridgoApplication app = new GridgoApplication(applicationClass, args);
        ThreadUtils.registerShutdownTask(() -> ((GridgoApplication)app).stop());
        try {
            app.start();
        }
        catch (Exception ex) {
            log.error("Application start failure", (Throwable)ex);
            app.stop();
        }
        return app;
    }

    private void initializeRegistry() {
        List<Method> methods = AnnotationUtils.findAllMethodsWithAnnotation(this.applicationClass, RegistryInitializer.class);
        for (Method method : methods) {
            try {
                int params = method.getParameterCount();
                if (params == 0) {
                    method.invoke(null, new Object[0]);
                    continue;
                }
                method.invoke(null, this.registry);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InitializationException("Cannot initialize application", e);
            }
        }
    }

    private void initializeContextWithAnnotation() {
        List<Method> methods = AnnotationUtils.findAllMethodsWithAnnotation(this.applicationClass, ContextInitializer.class);
        for (Method method : methods) {
            try {
                int params = method.getParameterCount();
                if (params == 0) {
                    method.invoke(null, new Object[0]);
                    continue;
                }
                method.invoke(null, this.context);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InitializationException("Cannot initialize application", e);
            }
        }
    }

    protected void onStart() {
        this.context.start();
    }

    protected void onStop() {
        this.context.stop();
    }

    protected String generateName() {
        return "app." + this.appName;
    }

    public GridgoContext getContext() {
        return this.context;
    }

    public String getAppName() {
        return this.appName;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Class<?> getApplicationClass() {
        return this.applicationClass;
    }

    public String[] getArgs() {
        return this.args;
    }

    public List<LazyInitializer> getLazyInitializers() {
        return this.lazyInitializers;
    }

    public FieldInjector getInjector() {
        return this.injector;
    }

    public List<AnnotationScanner> getScanners() {
        return this.scanners;
    }
}

