/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.config;

import io.gridgo.boot.support.exceptions.ResourceNotFoundException;
import io.gridgo.config.impl.AbstractConfigurator;
import io.gridgo.config.impl.AbstractLocalConfigurator;
import io.gridgo.config.impl.JsonConfigurator;

public class ResourceConfigurator
extends AbstractConfigurator {
    private static final String[] RESOURCES = new String[]{"gridgo-context.conf", "gridgo-context.yaml", "gridgo-context.yml", "gridgo-context.json"};
    private AbstractLocalConfigurator configurator = this.findConfigurator();

    public ResourceConfigurator() {
        this.configurator.subscribe(arg_0 -> ((ResourceConfigurator)this).publish(arg_0));
    }

    private AbstractLocalConfigurator findConfigurator() {
        for (String resource : RESOURCES) {
            Object url = this.getResource(resource);
            if (url == null || !resource.endsWith(".json")) continue;
            return JsonConfigurator.ofResource((String)resource);
        }
        throw new ResourceNotFoundException("No available resource not found");
    }

    private Object getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    protected void onStart() {
        this.configurator.start();
    }

    protected void onStop() {
        this.configurator.stop();
    }

    protected String generateName() {
        return "config.resource";
    }
}

