/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.data;

import io.gridgo.boot.data.DataAccessHandler;
import io.gridgo.boot.data.exceptions.SchemaNoHandlerException;
import io.gridgo.boot.data.support.annotations.DataAccess;
import io.gridgo.boot.data.support.annotations.DataAccessInject;
import io.gridgo.boot.data.support.annotations.DataAccessSchema;
import io.gridgo.boot.support.Injector;
import io.gridgo.boot.support.annotations.AnnotationUtils;
import io.gridgo.boot.support.exceptions.InitializationException;
import io.gridgo.boot.support.exceptions.InjectException;
import io.gridgo.connector.support.MessageProducer;
import io.gridgo.core.Gateway;
import io.gridgo.core.GridgoContext;
import io.gridgo.core.support.subscription.ConnectorAttachment;
import io.gridgo.utils.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAccessInjector
implements Injector {
    private static final Logger log = LoggerFactory.getLogger(DataAccessInjector.class);
    private final Map<String, Class<? extends DataAccessHandler>> handlerMap;
    private static final String[] DEFAULT_PACKAGE = new String[]{DataAccessInjector.class.getPackageName()};
    private GridgoContext context;

    public DataAccessInjector(GridgoContext context) {
        this.context = context;
        this.handlerMap = new HashMap<String, Class<? extends DataAccessHandler>>();
        this.loadAllHandlers();
    }

    private void loadAllHandlers() {
        CharSequence[] packages = DEFAULT_PACKAGE;
        String pkgNames = (String)this.context.getRegistry().lookup("gridgo.data.handlers.packages", String.class);
        if (pkgNames != null) {
            packages = pkgNames.split(",");
        }
        log.trace("Scanning packages {} for handlers", (Object)String.join((CharSequence)",", packages));
        Reflections ref = new Reflections((Object[])packages);
        Set types = ref.getSubTypesOf(DataAccessHandler.class);
        for (Class type : types) {
            this.registerType(type);
        }
    }

    private void registerType(Class<? extends DataAccessHandler> type) {
        String[] schemas;
        DataAccessSchema annotation = type.getAnnotation(DataAccessSchema.class);
        if (annotation == null) {
            log.warn("Class {} is not annotated with @DataAccessSchema", (Object)type.getName());
            return;
        }
        for (String schema : schemas = annotation.value().split(",")) {
            if (this.handlerMap.containsKey(schema)) {
                log.warn("Schema {} is already registered with a handler of type {}. It will be overriden", (Object)schema, (Object)this.handlerMap.get(schema).getName());
            }
            this.handlerMap.put(schema, type);
        }
    }

    @Override
    public void inject(Class<?> gatewayClass, Object instance) {
        List<Field> fields = AnnotationUtils.findAllFieldsWithAnnotation(gatewayClass, DataAccessInject.class);
        for (Field field : fields) {
            this.injectField(gatewayClass, instance, field);
        }
    }

    private void injectField(Class<?> clazz, Object instance, Field field) {
        Class<?> type = field.getType();
        DataAccess annotation = type.getAnnotation(DataAccess.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Field %s.%s of type %s is not annotated with @DataAccess", clazz.getName(), field.getName(), field.getType().getName()));
        }
        String targetGateway = annotation.gateway();
        if (targetGateway.isEmpty() && annotation.gatewayClass() != Void.TYPE) {
            targetGateway = annotation.gatewayClass().getName();
        }
        if (targetGateway.isEmpty()) {
            throw new InitializationException("The target gateway name must be specified");
        }
        String schema = this.detectSchema(targetGateway);
        if (!this.handlerMap.containsKey(schema)) {
            throw new SchemaNoHandlerException("No handler found for schema [" + schema + "]");
        }
        Object proxy = this.initDataAccessProxy(targetGateway, type, this.handlerMap.get(schema));
        ObjectUtils.setValue((Object)instance, (String)field.getName(), (Object)proxy);
    }

    private String detectSchema(String targetGateway) {
        Gateway gateway = this.context.findGatewayMandatory(targetGateway);
        List connectors = gateway.getConnectorAttachments();
        if (connectors.size() != 1) {
            throw new InjectException(String.format("Target gateway %s must have exactly 1 attached connector", targetGateway));
        }
        return ((ConnectorAttachment)connectors.get(0)).getConnector().getConnectorConfig().getConnectorCategory();
    }

    private Object initDataAccessProxy(String targetGateway, Class<?> proxyClass, Class<? extends DataAccessHandler> handler) {
        try {
            DataAccessHandler instance = handler.getConstructor(new Class[0]).newInstance(new Object[0]);
            instance.setContext(this.context);
            instance.setGateway((MessageProducer)this.context.findGatewayMandatory(targetGateway));
            return Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{proxyClass}, (InvocationHandler)instance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InitializationException("Cannot inject data access layer", e);
        }
    }
}

