/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.data;

import io.gridgo.bean.BArray;
import io.gridgo.bean.BElement;
import io.gridgo.bean.BObject;
import java.util.ArrayList;
import java.util.List;

public interface PojoConverter {
    default public Object toPojo(BElement body, Class<?> pojo) {
        if (body == null) {
            return null;
        }
        if (body.isObject()) {
            return this.toPojoObject(pojo, body.asObject());
        }
        if (body.isArray()) {
            return this.toPojoArray(pojo, body.asArray());
        }
        if (body.isReference()) {
            return this.toPojoReference(pojo, body);
        }
        throw new IllegalArgumentException(String.format("Result of type %s cannot be casted to %s", body.getType().name(), pojo.getClass().getName()));
    }

    default public Object toPojoReference(Class<?> pojo, BElement body) {
        if (pojo.isInstance(body.asReference())) {
            return body.asReference().getReference();
        }
        throw new IllegalArgumentException(String.format("Result of type %s cannot be casted to %s", body.asReference().getReference().getClass().getName(), pojo.getClass().getName()));
    }

    default public Object toPojoObject(Class<?> pojo, BObject body) {
        return body.toPojo(pojo);
    }

    default public List<?> toPojoArray(Class<?> pojo, BArray body) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < body.size(); ++i) {
            BObject e = ((BElement)body.get(i)).asObject();
            list.add(e.toPojo(pojo));
        }
        return list;
    }
}

