/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.data.jdbc;

import io.gridgo.bean.BObject;
import io.gridgo.boot.data.jdbc.Bind;
import io.gridgo.boot.data.jdbc.JdbcProduce;
import io.gridgo.boot.data.support.annotations.DataAccessSchema;
import io.gridgo.boot.data.support.impl.AbstractDataAccessHandler;
import io.gridgo.framework.support.Message;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataAccessSchema(value="jdbc")
public class JdbcDataAccessHandler
extends AbstractDataAccessHandler<JdbcProduce> {
    private static final Logger log = LoggerFactory.getLogger(JdbcDataAccessHandler.class);

    public JdbcDataAccessHandler() {
        super(JdbcProduce.class);
    }

    @Override
    protected Message buildMessage(JdbcProduce annotation, Method method, Object[] args) {
        BObject headers = BObject.ofEmpty();
        if (args != null) {
            Parameter[] params = method.getParameters();
            for (int i = 0; i < args.length; ++i) {
                Parameter param = params[i];
                Bind bind = param.getAnnotation(Bind.class);
                if (bind != null) {
                    headers.setAny(bind.value(), args[i]);
                    continue;
                }
                headers.setAny("" + (i + 1), args[i]);
            }
        }
        String query = this.context.getRegistry().substituteRegistriesRecursive(annotation.value());
        log.debug("Query: {}, params: {}", (Object)query, (Object)headers);
        return Message.ofAny((BObject)headers, (Object)query);
    }
}

