/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.data.keyvalue;

import io.gridgo.bean.BElement;
import io.gridgo.bean.BObject;
import io.gridgo.boot.data.keyvalue.BindKey;
import io.gridgo.boot.data.keyvalue.KeyValueOp;
import io.gridgo.boot.data.keyvalue.KeyValueProduce;
import io.gridgo.boot.data.support.annotations.DataAccessSchema;
import io.gridgo.boot.data.support.impl.AbstractDataAccessHandler;
import io.gridgo.framework.support.Message;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

@DataAccessSchema(value="keyvalue")
public class KeyValueDataAccessHandler
extends AbstractDataAccessHandler<KeyValueProduce> {
    public KeyValueDataAccessHandler() {
        super(KeyValueProduce.class);
    }

    @Override
    protected Message buildMessage(KeyValueProduce annotation, Method method, Object[] args) {
        String op = this.parseOperation(annotation.value());
        BObject headers = BObject.of((String)"Operation", (Object)op);
        BElement body = this.parseBody(annotation.value(), method, args);
        return Message.ofAny((BObject)headers, (Object)body);
    }

    private BElement parseBody(KeyValueOp op, Method method, Object[] args) {
        switch (op) {
            case DELETE: 
            case GET: {
                return this.parseBodyForGet(args);
            }
            case SET: {
                return this.parseBodyForSet(method, args);
            }
            case GET_ALL: {
                return null;
            }
        }
        return null;
    }

    protected BElement parseBodyForGet(Object[] args) {
        if (args == null || args.length != 1) {
            throw new IllegalArgumentException("GET/DELETE operation must have exactly 1 argument");
        }
        return BElement.ofAny((Object)args[0]);
    }

    protected BElement parseBodyForSet(Method method, Object[] args) {
        if (args == null || args.length != 1 && args.length != 2) {
            throw new IllegalArgumentException("SET operation must have either 1 or 2 arguments");
        }
        if (args.length == 1) {
            return BElement.ofAny((Object)args[0]);
        }
        Parameter[] params = method.getParameters();
        String key = null;
        Object value = null;
        for (int i = 0; i < args.length; ++i) {
            Parameter param = params[i];
            BindKey bind = param.getAnnotation(BindKey.class);
            if (bind != null) {
                key = args[i].toString();
                continue;
            }
            value = args[i];
        }
        if (key == null || value == null) {
            throw new IllegalArgumentException("Both key and value must be non-null for SET operation");
        }
        return BObject.of(key, value);
    }

    private String parseOperation(KeyValueOp value) {
        switch (value) {
            case GET: {
                return "Get";
            }
            case GET_ALL: {
                return "GetAll";
            }
            case SET: {
                return "Set";
            }
            case DELETE: {
                return "Delete";
            }
        }
        return null;
    }
}

