/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.data.support.impl;

import io.gridgo.bean.BArray;
import io.gridgo.bean.BElement;
import io.gridgo.boot.data.DataAccessHandler;
import io.gridgo.boot.data.PojoConverter;
import io.gridgo.boot.data.support.annotations.PojoMapper;
import io.gridgo.boot.data.support.annotations.SingleMapper;
import io.gridgo.connector.support.MessageProducer;
import io.gridgo.core.GridgoContext;
import io.gridgo.framework.support.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.joo.promise4j.Promise;

public abstract class AbstractDataAccessHandler<T extends Annotation>
implements DataAccessHandler,
PojoConverter {
    protected GridgoContext context;
    protected MessageProducer gateway;
    private final Class<? extends T> annotatedClass;

    public AbstractDataAccessHandler(Class<? extends T> annotatedClass) {
        this.annotatedClass = annotatedClass;
    }

    public Promise<?, Exception> invoke(Object proxy, Method method, Object[] args) throws Throwable {
        T annotation = method.getAnnotation(this.annotatedClass);
        if (annotation == null) {
            return Promise.ofCause((Throwable)new IllegalArgumentException(String.format("Method %s is not annotated with @%s", proxy.getClass().getName(), method.getName(), this.annotatedClass.getSimpleName())));
        }
        Message msgRequest = this.buildMessage(annotation, method, args);
        Promise msgResult = this.gateway.call(msgRequest);
        return msgResult.filterDone(r -> this.filterSingleMapper(method, (Message)r)).filterDone(r -> this.filterPojoMapper(method, r));
    }

    protected Object filterSingleMapper(Method method, Message result) {
        SingleMapper annotation = method.getAnnotation(SingleMapper.class);
        if (annotation == null) {
            return result;
        }
        if (result.body().isArray()) {
            BArray array = result.body().asArray();
            return array.isEmpty() ? null : array.get(0);
        }
        return result.body();
    }

    protected Object filterPojoMapper(Method method, Object result) {
        PojoMapper annotation = method.getAnnotation(PojoMapper.class);
        if (annotation == null) {
            return result;
        }
        Class<?> pojo = annotation.value();
        if (result instanceof Message) {
            return this.toPojo(((Message)result).body(), pojo);
        }
        return this.toPojo((BElement)result, pojo);
    }

    protected abstract Message buildMessage(T var1, Method var2, Object[] var3);

    public GridgoContext getContext() {
        return this.context;
    }

    public MessageProducer getGateway() {
        return this.gateway;
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.annotatedClass;
    }

    @Override
    public void setContext(GridgoContext context) {
        this.context = context;
    }

    @Override
    public void setGateway(MessageProducer gateway) {
        this.gateway = gateway;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDataAccessHandler)) {
            return false;
        }
        AbstractDataAccessHandler other = (AbstractDataAccessHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GridgoContext this$context = this.getContext();
        GridgoContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        MessageProducer this$gateway = this.getGateway();
        MessageProducer other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        Class<T> this$annotatedClass = this.getAnnotatedClass();
        Class<T> other$annotatedClass = other.getAnnotatedClass();
        return !(this$annotatedClass == null ? other$annotatedClass != null : !this$annotatedClass.equals(other$annotatedClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractDataAccessHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GridgoContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        MessageProducer $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        Class<T> $annotatedClass = this.getAnnotatedClass();
        result = result * 59 + ($annotatedClass == null ? 43 : $annotatedClass.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractDataAccessHandler(context=" + this.getContext() + ", gateway=" + this.getGateway() + ", annotatedClass=" + this.getAnnotatedClass() + ")";
    }
}

