/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.registry;

import io.gridgo.boot.registry.RegistryBuilder;
import io.gridgo.boot.support.annotations.AnnotationUtils;
import io.gridgo.boot.support.annotations.Registries;
import io.gridgo.boot.support.annotations.RegistryFactory;
import io.gridgo.boot.support.exceptions.InitializationException;
import io.gridgo.framework.support.Registry;
import io.gridgo.framework.support.impl.MultiSourceRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AnnotatedRegistry
implements Registry {
    private Registry registry;

    public AnnotatedRegistry(Class<?> applicationClass) {
        this.registry = this.extractRegistryFromAnnotation(applicationClass);
    }

    private Registry extractRegistryFromAnnotation(Class<?> applicationClass) {
        ArrayList<Registry> registries = new ArrayList<Registry>();
        String defaultProfile = null;
        String configPath = null;
        Registries annotation = applicationClass.getAnnotation(Registries.class);
        if (annotation != null) {
            registries.addAll(this.getRegistriesFromClassAnnotation(annotation));
            defaultProfile = annotation.defaultProfile();
            configPath = annotation.configPath();
        }
        MultiSourceRegistry registry = new RegistryBuilder().setDefaultProfile(defaultProfile).setConfigPath(configPath).setRegistries(registries.toArray(new Registry[0])).build();
        List<Registry> annotationRegistries = this.getAllMethodsWithAnnotations(applicationClass, registry);
        for (Registry annotationRegistry : annotationRegistries) {
            registry.addRegistry(annotationRegistry);
        }
        return registry;
    }

    private List<Registry> getAllMethodsWithAnnotations(Class<?> applicationClass, MultiSourceRegistry registry) {
        List<Method> methods = AnnotationUtils.findAllMethodsWithAnnotation(applicationClass, RegistryFactory.class);
        return methods.stream().map(method -> this.instantiateRegistry((Method)method, registry)).collect(Collectors.toList());
    }

    private List<Registry> getRegistriesFromClassAnnotation(Registries annotation) {
        return Arrays.stream(annotation.registries()).map(this::instantiateRegistry).collect(Collectors.toList());
    }

    private Registry instantiateRegistry(Method method, MultiSourceRegistry registry) {
        try {
            if (method.getParameterCount() == 0) {
                return (Registry)method.invoke(null, new Object[0]);
            }
            return (Registry)method.invoke(null, registry);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InitializationException("Cannot create registries", e);
        }
    }

    private Registry instantiateRegistry(Class<? extends Registry> registry) {
        try {
            return registry.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InitializationException("Cannot create registries", e);
        }
    }

    public Object lookup(String name) {
        return this.registry.lookup(name);
    }

    public Registry register(String name, Object answer) {
        this.registry.register(name, answer);
        return this;
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

