/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support;

import io.gridgo.bean.BObject;
import io.gridgo.boot.data.support.annotations.DataAccessInject;
import io.gridgo.boot.support.ContextSpoofingProcessor;
import io.gridgo.boot.support.annotations.ComponentInject;
import io.gridgo.boot.support.annotations.GatewayInject;
import io.gridgo.boot.support.annotations.RegistryInject;
import io.gridgo.core.Processor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BootContextSpoofingProcessor
extends ContextSpoofingProcessor {
    @Override
    protected BObject spoofProcessor(Processor processor) {
        BObject result = super.spoofProcessor(processor);
        List<?> injections = this.spoofInjection(processor);
        if (injections.isEmpty()) {
            return result;
        }
        return result.setAny("injections", injections);
    }

    private List<?> spoofInjection(Object processor) {
        return Arrays.stream(processor.getClass().getDeclaredFields()).map(f -> this.mapInjection(processor, (Field)f)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BObject mapInjection(Object processor, Field f) {
        String type = f.getType().getName();
        BObject result = BObject.of((String)"fieldName", (Object)f.getName()).setAny("fieldType", (Object)type);
        GatewayInject gatewayInject = f.getAnnotation(GatewayInject.class);
        if (gatewayInject != null) {
            return result.setAny("type", (Object)"gateway").setAny("target", (Object)(gatewayInject.value().isEmpty() ? gatewayInject.clazz().getName() : gatewayInject.value()));
        }
        RegistryInject registryInject = f.getAnnotation(RegistryInject.class);
        if (registryInject != null) {
            return result.setAny("type", (Object)"registry").setAny("target", (Object)registryInject.value());
        }
        ComponentInject componentInject = f.getAnnotation(ComponentInject.class);
        if (componentInject != null) {
            return result.setAny("type", (Object)"component").setAny("target", (Object)type);
        }
        DataAccessInject dataAccessInject = f.getAnnotation(DataAccessInject.class);
        if (dataAccessInject != null) {
            return result.setAny("type", (Object)"dataAccess").setAny("target", (Object)type);
        }
        return null;
    }
}

