/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support;

import io.gridgo.bean.BObject;
import io.gridgo.connector.Connector;
import io.gridgo.connector.support.config.ConnectorConfig;
import io.gridgo.core.GridgoContext;
import io.gridgo.core.Processor;
import io.gridgo.core.support.ContextAwareComponent;
import io.gridgo.core.support.RoutingContext;
import io.gridgo.core.support.subscription.ConnectorAttachment;
import io.gridgo.core.support.subscription.GatewaySubscription;
import io.gridgo.core.support.subscription.ProcessorSubscription;
import io.gridgo.core.support.subscription.RoutingPolicy;
import io.gridgo.framework.ComponentLifecycle;
import io.gridgo.framework.support.Message;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ContextSpoofingProcessor
implements Processor {
    public void process(RoutingContext rc, GridgoContext gc) {
        rc.getDeferred().resolve((Object)this.spoofContext(gc));
    }

    protected Message spoofContext(GridgoContext gc) {
        BObject gateways = BObject.ofEmpty();
        for (Map.Entry entry : gc.getGatewaysWithNames().entrySet()) {
            gateways.setAny((String)entry.getKey(), (Object)this.spoofGateway((GatewaySubscription)entry.getValue()));
        }
        List components = gc.getComponents().stream().map(this::spoofComponent).collect(Collectors.toList());
        BObject result = BObject.of((String)"name", (Object)gc.getName()).setAny("gateways", (Object)gateways).setAny("components", components);
        Message msg = Message.ofAny((Object)result);
        return msg;
    }

    protected BObject spoofComponent(ContextAwareComponent component) {
        return BObject.of((String)"name", (Object)component.getName()).setAny("class", (Object)component.getClass().getName()).setAny("started", (Object)component.isStarted());
    }

    protected BObject spoofGateway(GatewaySubscription subscription) {
        List connectors = subscription.get().getConnectorAttachments().stream().map(ConnectorAttachment::getConnector).map(this::spoofConnector).collect(Collectors.toList());
        List processors = subscription.getSubscriptions().stream().map(this::spoofSubscription).collect(Collectors.toList());
        return BObject.of((String)"connectors", connectors).setAny("subscriptions", processors).setAny("started", (Object)subscription.get().isStarted()).setAny("autoStart", (Object)subscription.get().isAutoStart());
    }

    protected BObject spoofConnector(Connector connector) {
        return BObject.of((String)"endpoint", (Object)this.spoofEndpoint(connector)).setAny("scheme", (Object)connector.getConnectorConfig().getScheme()).setAny("started", (Object)connector.isStarted()).setAny("consumer", (Object)this.extractName(connector.getConsumer())).setAny("producer", (Object)this.extractName(connector.getProducer()));
    }

    protected BObject spoofEndpoint(Connector connector) {
        ConnectorConfig config = connector.getConnectorConfig();
        return BObject.of((String)"scheme", (Object)config.getScheme()).setAny("rawEndpoint", (Object)(config.getScheme() + ":" + config.getOriginalEndpoint())).setAny("placeholders", (Object)config.getPlaceholders()).setAny("parameters", (Object)config.getParameters());
    }

    protected BObject spoofSubscription(ProcessorSubscription sub) {
        RoutingPolicy policy = sub.getPolicy();
        return BObject.of((String)"processor", (Object)this.spoofProcessor(policy.getProcessor())).setAny("strategy", (Object)this.extractName(policy.getStrategy())).setAny("instrumenter", policy.getInstrumenter().map(i -> i.getClass().getName()).orElse(null));
    }

    protected BObject spoofProcessor(Processor processor) {
        return BObject.of((String)"class", (Object)processor.getClass().getName());
    }

    private String extractName(Optional<? extends ComponentLifecycle> component) {
        return component.map(c -> c.getName()).orElse(null);
    }
}

