/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support;

import io.gridgo.boot.data.DataAccessInjector;
import io.gridgo.boot.support.Injector;
import io.gridgo.boot.support.annotations.AnnotationUtils;
import io.gridgo.boot.support.annotations.PostConstruct;
import io.gridgo.boot.support.exceptions.InitializationException;
import io.gridgo.boot.support.injectors.impl.ComponentInjector;
import io.gridgo.boot.support.injectors.impl.GatewayInjector;
import io.gridgo.boot.support.injectors.impl.RegistryInjector;
import io.gridgo.core.GridgoContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public class FieldInjector {
    private List<Injector> injectors;

    public FieldInjector(GridgoContext context) {
        this.injectors = Arrays.asList(new RegistryInjector(context), new GatewayInjector(context), new ComponentInjector(context), new DataAccessInjector(context));
    }

    public void injectFields(Class<?> gatewayClass, Object instance) {
        for (Injector injector : this.injectors) {
            injector.inject(gatewayClass, instance);
        }
        this.postConstructInitialize(gatewayClass, instance);
    }

    private void postConstructInitialize(Class<?> gatewayClass, Object instance) {
        List<Method> postConstructs = AnnotationUtils.findAllMethodsWithAnnotation(gatewayClass, PostConstruct.class);
        if (postConstructs.size() >= 2) {
            throw new InitializationException("Only one PostConstruct method in a component be used");
        }
        if (postConstructs.size() == 1) {
            Method postConstruct = postConstructs.get(0);
            try {
                if (Modifier.isStatic(postConstruct.getModifiers())) {
                    postConstruct.invoke(null, new Object[0]);
                } else {
                    postConstruct.invoke(instance, new Object[0]);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InitializationException("Cannot initialize the PostConstruct", e);
            }
        }
    }
}

