/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AnnotationUtils {
    public static List<Method> findAllDeclaredMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return AnnotationUtils.findAllMethodsWithAnnotation(clazz, annotation, true);
    }

    public static List<Method> findAllMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return AnnotationUtils.findAllMethodsWithAnnotation(clazz, annotation, false);
    }

    public static List<Method> findAllMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation, boolean declared) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != Object.class) {
            List allMethods = Arrays.stream(declared ? clazz.getDeclaredMethods() : clazz.getMethods()).filter(method -> method.isAnnotationPresent(annotation)).collect(Collectors.toList());
            methods.addAll(allMethods);
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    public static List<Field> findAllFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(annotation)).collect(Collectors.toList());
    }
}

