/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support.injectors.impl;

import io.gridgo.boot.support.Injector;
import io.gridgo.boot.support.annotations.AnnotationUtils;
import io.gridgo.boot.support.annotations.ComponentInject;
import io.gridgo.core.GridgoContext;
import io.gridgo.framework.support.Registry;
import io.gridgo.utils.ObjectUtils;
import java.lang.reflect.Field;
import java.util.List;

public class ComponentInjector
implements Injector {
    private GridgoContext context;

    public ComponentInjector(GridgoContext context) {
        this.context = context;
    }

    @Override
    public void inject(Class<?> gatewayClass, Object instance) {
        List<Field> fields = AnnotationUtils.findAllFieldsWithAnnotation(gatewayClass, ComponentInject.class);
        for (Field field : fields) {
            String name = field.getName();
            Class<?> clazz = field.getType();
            String injectedKey = field.getAnnotation(ComponentInject.class).value();
            Object component = this.lookupComponent(clazz, injectedKey);
            ObjectUtils.setValue((Object)instance, (String)name, (Object)component);
        }
    }

    protected Object lookupComponent(Class<?> clazz, String injectedKey) {
        Registry registry = this.context.getRegistry();
        String name = injectedKey.isEmpty() ? clazz.getName() : registry.substituteRegistriesRecursive(injectedKey);
        return registry.lookupMandatory(name, clazz);
    }
}

