/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support.injectors.impl;

import io.gridgo.boot.support.Injector;
import io.gridgo.boot.support.annotations.AnnotationUtils;
import io.gridgo.boot.support.annotations.RegistryInject;
import io.gridgo.core.GridgoContext;
import io.gridgo.utils.ObjectUtils;
import java.lang.reflect.Field;
import java.util.List;

public class RegistryInjector
implements Injector {
    private GridgoContext context;

    public RegistryInjector(GridgoContext context) {
        this.context = context;
    }

    @Override
    public void inject(Class<?> gatewayClass, Object instance) {
        List<Field> fields = AnnotationUtils.findAllFieldsWithAnnotation(gatewayClass, RegistryInject.class);
        for (Field field : fields) {
            String name = field.getName();
            String injectedKey = field.getAnnotation(RegistryInject.class).value();
            Object injectedValue = this.context.getRegistry().lookup(injectedKey, field.getType());
            ObjectUtils.setValue((Object)instance, (String)name, (Object)injectedValue);
        }
    }
}

