/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support.scanners.impl;

import io.gridgo.boot.support.annotations.RegistryInject;
import io.gridgo.core.GridgoContext;
import io.gridgo.core.support.exceptions.AmbiguousException;
import io.gridgo.framework.support.Registry;
import io.gridgo.framework.support.exceptions.BeanNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;

public interface ClassResolver {
    default public Object resolveClass(Class<?> clazz, GridgoContext context) {
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length > 1) {
                throw new AmbiguousException("Only one constructor is allowed");
            }
            Constructor<?> constructor = constructors[0];
            Object[] params = Arrays.stream(constructor.getParameters()).map(type -> this.lookupForType(context, (Parameter)type)).toArray(Object[]::new);
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot resolve class " + clazz, e);
        }
    }

    default public Object lookupForType(GridgoContext context, Parameter param) {
        Class<?> type = param.getType();
        if (type == GridgoContext.class) {
            return context;
        }
        if (type == Registry.class) {
            return context.getRegistry();
        }
        RegistryInject annotation = param.getAnnotation(RegistryInject.class);
        if (annotation != null) {
            return context.getRegistry().lookupMandatory(annotation.value(), param.getType());
        }
        throw new BeanNotFoundException("Cannot find any bean with the required type " + param.getType());
    }
}

