/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support.scanners.impl;

import io.gridgo.boot.support.AnnotationScanner;
import io.gridgo.boot.support.LazyInitializer;
import io.gridgo.boot.support.annotations.Component;
import io.gridgo.boot.support.exceptions.InitializationException;
import io.gridgo.boot.support.scanners.impl.ClassResolver;
import io.gridgo.core.GridgoContext;
import io.gridgo.core.support.ContextAwareComponent;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;

public class ComponentScanner
implements AnnotationScanner,
ClassResolver {
    @Override
    public void scanAnnotation(Reflections ref, GridgoContext context, List<LazyInitializer> lazyInitializers) {
        Set components = ref.getTypesAnnotatedWith(Component.class);
        for (Class comp : components) {
            this.registerComponent(context, comp, lazyInitializers);
        }
    }

    private void registerComponent(GridgoContext context, Class<?> comp, List<LazyInitializer> lazyInitializers) {
        Component annotation = comp.getAnnotation(Component.class);
        String name = annotation.value();
        try {
            Object instance = this.resolveClass(comp, context);
            if (!name.isEmpty()) {
                context.getRegistry().register(name, instance);
            } else {
                context.getRegistry().register(comp.getName(), instance);
            }
            if (instance instanceof ContextAwareComponent) {
                context.attachComponent((ContextAwareComponent)instance);
            }
            lazyInitializers.add(new LazyInitializer(comp, instance));
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new InitializationException("Cannot register processor", e);
        }
    }
}

