/*
 * Decompiled with CFR 0.152.
 */
package io.gridgo.boot.support.scanners.impl;

import io.gridgo.boot.support.AnnotationScanner;
import io.gridgo.boot.support.LazyInitializer;
import io.gridgo.boot.support.annotations.Connector;
import io.gridgo.boot.support.annotations.Gateway;
import io.gridgo.boot.support.annotations.Instrumenter;
import io.gridgo.boot.support.scanners.impl.ClassResolver;
import io.gridgo.connector.support.config.ConnectorContext;
import io.gridgo.connector.support.config.ConnectorContextBuilder;
import io.gridgo.core.GridgoContext;
import io.gridgo.core.Processor;
import io.gridgo.core.support.subscription.ConnectorAttachment;
import io.gridgo.core.support.subscription.GatewaySubscription;
import io.gridgo.core.support.transformers.MessageTransformer;
import io.gridgo.core.support.transformers.impl.FormattedDeserializeMessageTransformer;
import io.gridgo.core.support.transformers.impl.FormattedSerializeMessageTransformer;
import io.gridgo.core.support.transformers.impl.WrappedMessageTransformer;
import io.gridgo.framework.execution.ExecutionStrategy;
import io.gridgo.framework.execution.ExecutionStrategyInstrumenter;
import io.gridgo.framework.execution.ProducerInstrumenter;
import io.gridgo.framework.support.Registry;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;

public class GatewayScanner
implements AnnotationScanner,
ClassResolver {
    @Override
    public void scanAnnotation(Reflections ref, GridgoContext context, List<LazyInitializer> lazyInitializers) {
        Set gateways = ref.getTypesAnnotatedWith(Gateway.class);
        for (Class gateway : gateways) {
            this.registerGateway(context, gateway, lazyInitializers);
        }
    }

    private void registerGateway(GridgoContext context, Class<?> gatewayClass, List<LazyInitializer> lazyInitializers) {
        Gateway annotation = gatewayClass.getAnnotation(Gateway.class);
        String name = annotation.value().isEmpty() ? gatewayClass.getName() : annotation.value();
        GatewaySubscription gateway = context.openGateway(name).setAutoStart(annotation.autoStart());
        this.attachConnectors(context.getRegistry(), gatewayClass, gateway);
        Object instance = this.resolveClass(gatewayClass, context);
        gateway.setProducerInstrumenter(this.extractProducerInstrumenter(context.getRegistry(), gatewayClass));
        this.subscribeProcessor(context.getRegistry(), gatewayClass, gateway, instance);
        lazyInitializers.add(new LazyInitializer(gatewayClass, instance));
    }

    private void subscribeProcessor(Registry registry, Class<?> gatewayClass, GatewaySubscription gateway, Object instance) {
        ExecutionStrategy executionStrategy = this.extractExecutionStrategy(registry, gatewayClass);
        ExecutionStrategyInstrumenter instrumenter = this.extractInstrumenter(registry, gatewayClass);
        if (instance instanceof Processor) {
            gateway.subscribe((Processor)instance).using(executionStrategy).instrumentWith(instrumenter);
        }
    }

    private void attachConnectors(Registry registry, Class<?> gatewayClass, GatewaySubscription gateway) {
        Connector[] connectors;
        for (Connector connector : connectors = (Connector[])gatewayClass.getAnnotationsByType(Connector.class)) {
            MessageTransformer outgoingTransformer;
            String endpoint = registry.substituteRegistriesRecursive(connector.value());
            ConnectorAttachment attachment = null;
            if (connector.builder().isBlank()) {
                attachment = gateway.attachConnector(endpoint);
            } else {
                ConnectorContextBuilder builder = (ConnectorContextBuilder)registry.lookupMandatory(connector.builder(), ConnectorContextBuilder.class);
                attachment = gateway.attachConnector(endpoint, (ConnectorContext)builder.build());
            }
            MessageTransformer incomingTransformer = this.extractTransformer(registry, connector.incomingFormat(), connector.incomingTransformers(), true);
            if (incomingTransformer != null) {
                attachment.transformIncomingWith(incomingTransformer);
            }
            if ((outgoingTransformer = this.extractTransformer(registry, connector.outgoingFormat(), connector.outgoingTransformers(), false)) == null) continue;
            attachment.transformOutgoingWith(outgoingTransformer);
        }
    }

    private MessageTransformer extractTransformer(Registry registry, String format, String[] transformers, boolean incoming) {
        if (format.isEmpty() && transformers.length == 0) {
            return null;
        }
        List<MessageTransformer> list = Arrays.stream(transformers).map(transformer -> (MessageTransformer)registry.lookupMandatory(transformer, MessageTransformer.class)).collect(Collectors.toList());
        if (!format.isEmpty()) {
            FormattedDeserializeMessageTransformer formatter = incoming ? new FormattedDeserializeMessageTransformer(format) : new FormattedSerializeMessageTransformer(format);
            list.add((MessageTransformer)formatter);
        }
        if (list.size() == 1) {
            return (MessageTransformer)list.get(0);
        }
        return new WrappedMessageTransformer(list.toArray(new MessageTransformer[0]));
    }

    private ExecutionStrategy extractExecutionStrategy(Registry registry, Class<?> gatewayClass) {
        io.gridgo.boot.support.annotations.ExecutionStrategy executionStrategy = gatewayClass.getAnnotation(io.gridgo.boot.support.annotations.ExecutionStrategy.class);
        if (executionStrategy == null) {
            return null;
        }
        return (ExecutionStrategy)registry.lookupMandatory(executionStrategy.value(), ExecutionStrategy.class);
    }

    private ExecutionStrategyInstrumenter extractInstrumenter(Registry registry, Class<?> gatewayClass) {
        Instrumenter instrumenter = gatewayClass.getAnnotation(Instrumenter.class);
        if (instrumenter == null) {
            return null;
        }
        return (ExecutionStrategyInstrumenter)registry.lookupMandatory(instrumenter.value(), ExecutionStrategyInstrumenter.class);
    }

    private ProducerInstrumenter extractProducerInstrumenter(Registry registry, Class<?> gatewayClass) {
        io.gridgo.boot.support.annotations.ProducerInstrumenter instrumenter = gatewayClass.getAnnotation(io.gridgo.boot.support.annotations.ProducerInstrumenter.class);
        if (instrumenter == null) {
            return null;
        }
        return (ProducerInstrumenter)registry.lookupMandatory(instrumenter.value(), ProducerInstrumenter.class);
    }
}

