/*
 * Decompiled with CFR 0.152.
 */
package io.grovs.model;

import android.util.Log;
import io.grovs.model.LogLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/grovs/model/DebugLogger;", "", "()V", "logLevel", "Lio/grovs/model/LogLevel;", "getLogLevel", "()Lio/grovs/model/LogLevel;", "setLogLevel", "(Lio/grovs/model/LogLevel;)V", "log", "", "level", "message", "", "Companion", "Grovs_release"})
public final class DebugLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LogLevel logLevel = LogLevel.ERROR;
    @NotNull
    private static final DebugLogger instance = new DebugLogger();

    @NotNull
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        this.logLevel = logLevel;
    }

    public final void log(@NotNull LogLevel level, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.logLevel == LogLevel.ERROR && level == LogLevel.INFO) {
            return;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement element = stackTrace[1];
        String fileName = element.getFileName();
        String functionName = element.getMethodName();
        int lineNumber = element.getLineNumber();
        String logMessage = "\ud83d\udd17GROVS [" + level.name() + "] " + fileName + " -> " + functionName + " [Line " + lineNumber + "]: " + message;
        if (level == LogLevel.ERROR) {
            logMessage = "\n\n\n" + logMessage + "\n\n\n";
        }
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                Log.d((String)"Logger", (String)logMessage);
                break;
            }
            case 2: {
                Log.e((String)"Logger", (String)logMessage);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/grovs/model/DebugLogger$Companion;", "", "()V", "instance", "Lio/grovs/model/DebugLogger;", "getInstance", "()Lio/grovs/model/DebugLogger;", "Grovs_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DebugLogger getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

