/*
 * Decompiled with CFR 0.152.
 */
package io.grovs.utils;

import android.os.Parcel;
import android.os.Parcelable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 #2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\t\u0010\r\u001a\u00020\tH\u00d6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\tH\u00d6\u0001J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0019\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lio/grovs/utils/InstantCompat;", "Landroid/os/Parcelable;", "", "epochMillis", "", "(J)V", "getEpochMillis", "()J", "compareTo", "", "other", "component1", "copy", "describeContents", "equals", "", "", "hashCode", "isAfter", "isBefore", "minusMillis", "millisToSubtract", "plusMillis", "millisToAdd", "toDate", "Ljava/util/Date;", "toEpochMilli", "toIsoString", "", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "Grovs_release"})
@Parcelize
public final class InstantCompat
implements Parcelable,
Comparable<InstantCompat> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long epochMillis;
    @NotNull
    public static final Parcelable.Creator<InstantCompat> CREATOR;

    public InstantCompat(long epochMillis) {
        this.epochMillis = epochMillis;
    }

    public final long getEpochMillis() {
        return this.epochMillis;
    }

    public final long toEpochMilli() {
        return this.epochMillis;
    }

    @NotNull
    public final String toIsoString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = sdf.format(new Date(this.epochMillis));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdf.format(Date(epochMillis))");
        return string;
    }

    @NotNull
    public final Date toDate() {
        return new Date(this.epochMillis);
    }

    @NotNull
    public final InstantCompat plusMillis(long millisToAdd) {
        return new InstantCompat(this.epochMillis + millisToAdd);
    }

    @NotNull
    public final InstantCompat minusMillis(long millisToSubtract) {
        return new InstantCompat(this.epochMillis - millisToSubtract);
    }

    public final boolean isBefore(@NotNull InstantCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.epochMillis < other.epochMillis;
    }

    public final boolean isAfter(@NotNull InstantCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.epochMillis > other.epochMillis;
    }

    @NotNull
    public String toString() {
        return this.toIsoString();
    }

    @Override
    public int compareTo(@NotNull InstantCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.epochMillis, (long)other.epochMillis);
    }

    public final long component1() {
        return this.epochMillis;
    }

    @NotNull
    public final InstantCompat copy(long epochMillis) {
        return new InstantCompat(epochMillis);
    }

    public static /* synthetic */ InstantCompat copy$default(InstantCompat instantCompat, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = instantCompat.epochMillis;
        }
        return instantCompat.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.epochMillis);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstantCompat)) {
            return false;
        }
        InstantCompat instantCompat = (InstantCompat)other;
        return this.epochMillis == instantCompat.epochMillis;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeLong(this.epochMillis);
    }

    static {
        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<InstantCompat> {
            @NotNull
            public final InstantCompat[] newArray(int size) {
                return new InstantCompat[size];
            }

            @NotNull
            public final InstantCompat createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new InstantCompat(parcel.readLong());
            }
        }
        CREATOR = new Creator();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lio/grovs/utils/InstantCompat$Companion;", "", "()V", "now", "Lio/grovs/utils/InstantCompat;", "ofEpochMilli", "millis", "", "ofEpochSecond", "seconds", "nanosAdjustment", "parse", "iso8601", "", "Grovs_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InstantCompat now() {
            return new InstantCompat(System.currentTimeMillis());
        }

        @NotNull
        public final InstantCompat ofEpochMilli(long millis) {
            return new InstantCompat(millis);
        }

        @NotNull
        public final InstantCompat ofEpochSecond(long seconds, long nanosAdjustment) {
            long millis = seconds * (long)1000 + nanosAdjustment / (long)1000000;
            return new InstantCompat(millis);
        }

        public static /* synthetic */ InstantCompat ofEpochSecond$default(Companion companion, long l, long l2, int n, Object object) {
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            return companion.ofEpochSecond(l, l2);
        }

        @NotNull
        public final InstantCompat parse(@NotNull String iso8601) {
            Intrinsics.checkNotNullParameter((Object)iso8601, (String)"iso8601");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = sdf.parse(iso8601);
            if (date == null) {
                throw new IllegalArgumentException("Invalid ISO 8601 string: " + iso8601);
            }
            Date date2 = date;
            return new InstantCompat(date2.getTime());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

