/*
 * Decompiled with CFR 0.152.
 */
package io.grovs.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/grovs/utils/WebViewUtils;", "", "()V", "Companion", "Grovs_release"})
public final class WebViewUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String defaultUserAgent = "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Mobile Safari/537.36";
    @Nullable
    private static String cachedUserAgent;

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/grovs/utils/WebViewUtils$Companion;", "", "()V", "cachedUserAgent", "", "defaultUserAgent", "getChromeVersion", "context", "Landroid/content/Context;", "getUserAgent", "parseUserAgent", "userAgent", "browserVersion", "Grovs_release"})
    @SourceDebugExtension(value={"SMAP\nWebViewUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewUtils.kt\nio/grovs/utils/WebViewUtils$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUserAgent(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = cachedUserAgent;
            if (string != null) {
                String it = string;
                boolean bl = false;
                return it;
            }
            try {
                String string2 = Thread.currentThread().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentThread().name");
                if (StringsKt.contains((CharSequence)string2, (CharSequence)"main", (boolean)true)) {
                    WebView webView = new WebView(context);
                    WebSettings webSettings = webView.getSettings();
                    Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"webView.settings");
                    WebSettings webSettings2 = webSettings;
                    String userAgent2 = webSettings2.getUserAgentString();
                    Intrinsics.checkNotNullExpressionValue((Object)userAgent2, (String)"userAgent");
                    String processedUserAgent = this.parseUserAgent(userAgent2, this.getChromeVersion(context));
                    cachedUserAgent = processedUserAgent;
                    return processedUserAgent;
                }
                String result2 = (String)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(context, null){
                    int label;
                    final /* synthetic */ Context $context;
                    {
                        this.$context = $context;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                WebView webView = new WebView(this.$context);
                                WebSettings webSettings = webView.getSettings();
                                Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"webView.settings");
                                WebSettings webSettings2 = webSettings;
                                String userAgent2 = webSettings2.getUserAgentString();
                                Intrinsics.checkNotNullExpressionValue((Object)userAgent2, (String)"userAgent");
                                String processedUserAgent = WebViewUtils.Companion.parseUserAgent(userAgent2, WebViewUtils.Companion.getChromeVersion(this.$context));
                                return processedUserAgent;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                cachedUserAgent = result2;
                return result2;
            }
            catch (Exception e) {
                return defaultUserAgent;
            }
        }

        @NotNull
        public final String parseUserAgent(@NotNull String userAgent2, @Nullable String browserVersion) {
            Intrinsics.checkNotNullParameter((Object)userAgent2, (String)"userAgent");
            try {
                Object object;
                String browserName;
                Object object2;
                String string;
                Object browserEngine;
                Object object3;
                Object mozillaVersion;
                Regex mozillaVersionRegex = new Regex("Mozilla/(\\d+\\.\\d+)");
                Regex browserEngineRegex = new Regex("AppleWebKit/(\\d+\\.\\d+)");
                Regex browserNameRegex = new Regex("Chrome/(\\d+)");
                Regex mobileSafariVersionRegex = new Regex("Mobile Safari/(\\d+\\.\\d+)");
                Object object4 = Regex.find$default((Regex)mozillaVersionRegex, (CharSequence)userAgent2, (int)0, (int)2, null);
                if (object4 == null || (object4 = object4.getGroupValues()) == null || (object4 = (String)object4.get(1)) == null) {
                    object4 = mozillaVersion = "5.0";
                }
                if ((object3 = Regex.find$default((Regex)browserEngineRegex, (CharSequence)userAgent2, (int)0, (int)2, null)) == null || (object3 = object3.getGroupValues()) == null || (object3 = (String)object3.get(1)) == null) {
                    object3 = browserEngine = "537.36";
                }
                if ((string = browserVersion) == null && ((object2 = Regex.find$default((Regex)browserNameRegex, (CharSequence)userAgent2, (int)0, (int)2, null)) != null && (object2 = object2.getGroupValues()) != null ? (String)object2.get(1) : (string = null)) == null) {
                    string = browserName = "127";
                }
                if ((object = Regex.find$default((Regex)mobileSafariVersionRegex, (CharSequence)userAgent2, (int)0, (int)2, null)) == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                    object = "537.36";
                }
                Object mobileSafariVersion = object;
                return "Mozilla/" + (String)mozillaVersion + " (Linux; Android 10; K) AppleWebKit/" + (String)browserEngine + " (KHTML, like Gecko) Chrome/" + browserName + ".0.0.0 Mobile Safari/" + (String)mobileSafariVersion;
            }
            catch (Exception e) {
                return defaultUserAgent;
            }
        }

        @Nullable
        public final String getChromeVersion(@NotNull Context context) {
            String string;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String chromePackage = "com.android.chrome";
            PackageManager packageManager = context.getPackageManager();
            try {
                String fullVersion;
                PackageInfo packageInfo;
                if (Build.VERSION.SDK_INT >= 33) {
                    PackageInfo packageInfo2 = packageManager.getPackageInfo(chromePackage, PackageManager.PackageInfoFlags.of((long)0L));
                    packageInfo = packageInfo2;
                    Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"{\n                    //\u2026      )\n                }");
                } else {
                    PackageInfo packageInfo3 = packageManager.getPackageInfo(chromePackage, 0);
                    packageInfo = packageInfo3;
                    Intrinsics.checkNotNullExpressionValue((Object)packageInfo3, (String)"{\n                    //\u2026age, 0)\n                }");
                }
                PackageInfo packageInfo4 = packageInfo;
                String string2 = fullVersion = packageInfo4.versionName;
                string = string2 != null ? StringsKt.substringBefore$default((String)string2, (char)'.', null, (int)2, null) : null;
            }
            catch (PackageManager.NameNotFoundException e) {
                string = null;
            }
            catch (Exception e) {
                string = null;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

