/*
 * Decompiled with CFR 0.152.
 */
package io.grovs.utils;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\nH\u00d6\u0001J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lio/grovs/utils/InstantCompat;", "Landroid/os/Parcelable;", "epochMillis", "", "(J)V", "getEpochMillis", "()J", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "isAfter", "isBefore", "minusMillis", "millisToSubtract", "plusMillis", "millisToAdd", "toDate", "Ljava/util/Date;", "toEpochMilli", "toIsoString", "", "toIsoUsingJavaTime", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "Grovs_release"})
@Parcelize
public final class InstantCompat
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long epochMillis;
    @NotNull
    public static final Parcelable.Creator<InstantCompat> CREATOR;

    public InstantCompat(long epochMillis) {
        this.epochMillis = epochMillis;
    }

    public final long getEpochMillis() {
        return this.epochMillis;
    }

    public final long toEpochMilli() {
        return this.epochMillis;
    }

    @NotNull
    public final String toIsoString() {
        String string;
        if (Build.VERSION.SDK_INT >= 26) {
            string = this.toIsoUsingJavaTime();
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String string2 = sdf.format(new Date(this.epochMillis));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            val sdf = \u2026e(epochMillis))\n        }");
        }
        return string;
    }

    @NotNull
    public final Date toDate() {
        return new Date(this.epochMillis);
    }

    private final String toIsoUsingJavaTime() {
        Class<?> instantClass = Class.forName("java.time.Instant");
        Class[] classArray = new Class[]{Long.TYPE};
        Method ofEpochMilliMethod = instantClass.getMethod("ofEpochMilli", classArray);
        Object[] objectArray = new Object[]{this.epochMillis};
        Object instantObj = ofEpochMilliMethod.invoke(null, objectArray);
        return instantObj.toString();
    }

    @NotNull
    public final InstantCompat plusMillis(long millisToAdd) {
        return new InstantCompat(this.epochMillis + millisToAdd);
    }

    @NotNull
    public final InstantCompat minusMillis(long millisToSubtract) {
        return new InstantCompat(this.epochMillis - millisToSubtract);
    }

    public final boolean isBefore(@NotNull InstantCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.epochMillis < other.epochMillis;
    }

    public final boolean isAfter(@NotNull InstantCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.epochMillis > other.epochMillis;
    }

    @NotNull
    public String toString() {
        return this.toIsoString();
    }

    public final long component1() {
        return this.epochMillis;
    }

    @NotNull
    public final InstantCompat copy(long epochMillis) {
        return new InstantCompat(epochMillis);
    }

    public static /* synthetic */ InstantCompat copy$default(InstantCompat instantCompat, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = instantCompat.epochMillis;
        }
        return instantCompat.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.epochMillis);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstantCompat)) {
            return false;
        }
        InstantCompat instantCompat = (InstantCompat)other;
        return this.epochMillis == instantCompat.epochMillis;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeLong(this.epochMillis);
    }

    static {
        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<InstantCompat> {
            @NotNull
            public final InstantCompat[] newArray(int size) {
                return new InstantCompat[size];
            }

            @NotNull
            public final InstantCompat createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new InstantCompat(parcel.readLong());
            }
        }
        CREATOR = new Creator();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lio/grovs/utils/InstantCompat$Companion;", "", "()V", "now", "Lio/grovs/utils/InstantCompat;", "ofEpochMilli", "millis", "", "ofEpochSecond", "seconds", "nanosAdjustment", "parse", "iso8601", "", "parseUsingJavaTime", "Grovs_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InstantCompat now() {
            return new InstantCompat(System.currentTimeMillis());
        }

        @NotNull
        public final InstantCompat ofEpochMilli(long millis) {
            return new InstantCompat(millis);
        }

        @NotNull
        public final InstantCompat ofEpochSecond(long seconds, long nanosAdjustment) {
            long millis = seconds * (long)1000 + nanosAdjustment / (long)1000000;
            return new InstantCompat(millis);
        }

        public static /* synthetic */ InstantCompat ofEpochSecond$default(Companion companion, long l, long l2, int n, Object object) {
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            return companion.ofEpochSecond(l, l2);
        }

        @NotNull
        public final InstantCompat parse(@NotNull String iso8601) {
            InstantCompat instantCompat;
            Intrinsics.checkNotNullParameter((Object)iso8601, (String)"iso8601");
            if (Build.VERSION.SDK_INT >= 26) {
                instantCompat = this.parseUsingJavaTime(iso8601);
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                String adjusted = StringsKt.replace$default((String)StringsKt.replace$default((String)iso8601, (String)"Z", (String)"+0000", (boolean)false, (int)4, null), (String)":", (String)"", (boolean)false, (int)4, null);
                Date date = sdf.parse(adjusted);
                if (date == null) {
                    throw new IllegalArgumentException("Invalid ISO 8601 string: " + iso8601);
                }
                Date date2 = date;
                instantCompat = new InstantCompat(date2.getTime());
            }
            return instantCompat;
        }

        private final InstantCompat parseUsingJavaTime(String iso8601) {
            Class<?> instantClass = Class.forName("java.time.Instant");
            Class[] classArray = new Class[]{CharSequence.class};
            Method parseMethod = instantClass.getMethod("parse", classArray);
            Object[] objectArray = new Object[]{iso8601};
            Object instantObj = parseMethod.invoke(null, objectArray);
            Method toEpochMilliMethod = instantClass.getMethod("toEpochMilli", new Class[0]);
            Object object = toEpochMilliMethod.invoke(instantObj, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            long epochMillis = (Long)object;
            return new InstantCompat(epochMillis);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

