/*
 * Decompiled with CFR 0.152.
 */
package io.grovs.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.grovs.adapters.NotificationsListItem;
import io.grovs.databinding.LayoutNotificationListItemBinding;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\"#B>\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018H\u0016J\u0014\u0010!\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R,\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lio/grovs/adapters/NotificationsListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "data", "", "Lio/grovs/adapters/NotificationsListItem;", "onNotificationSelected", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "item", "", "(Landroid/content/Context;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "getContext", "()Landroid/content/Context;", "getData", "()Ljava/util/List;", "setData", "(Ljava/util/List;)V", "getOnNotificationSelected", "()Lkotlin/jvm/functions/Function1;", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "updateData", "LayoutNotificationListItemHolder", "NotificationSelectionItemTypes", "Grovs_release"})
public final class NotificationsListAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final Context context;
    @NotNull
    private List<? extends NotificationsListItem> data;
    @NotNull
    private final Function1<NotificationsListItem, Unit> onNotificationSelected;

    public NotificationsListAdapter(@NotNull Context context, @NotNull List<? extends NotificationsListItem> data, @NotNull Function1<? super NotificationsListItem, Unit> onNotificationSelected) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(onNotificationSelected, (String)"onNotificationSelected");
        this.context = context;
        this.data = data;
        this.onNotificationSelected = onNotificationSelected;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final List<NotificationsListItem> getData() {
        return this.data;
    }

    public final void setData(@NotNull List<? extends NotificationsListItem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.data = list;
    }

    @NotNull
    public final Function1<NotificationsListItem, Unit> getOnNotificationSelected() {
        return this.onNotificationSelected;
    }

    public int getItemViewType(int position) {
        NotificationsListItem item = this.data.get(position);
        if (!(item instanceof NotificationsListItem.Notification)) {
            throw new NoWhenBranchMatchedException();
        }
        return NotificationSelectionItemTypes.ITEM.getValue();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        if (viewType != NotificationSelectionItemTypes.ITEM.getValue()) {
            throw new IllegalStateException("Invalid type");
        }
        LayoutNotificationListItemBinding layoutNotificationListItemBinding = LayoutNotificationListItemBinding.inflate(layoutInflater, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)layoutNotificationListItemBinding, (String)"inflate(layoutInflater, parent, false)");
        return new LayoutNotificationListItemHolder(layoutNotificationListItemBinding, this.context);
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        block7: {
            Object object;
            Object object2;
            Object object3;
            LayoutNotificationListItemHolder viewHolder;
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            NotificationsListItem item = this.data.get(position);
            if (!(item instanceof NotificationsListItem.Notification)) break block7;
            LayoutNotificationListItemHolder layoutNotificationListItemHolder = viewHolder = holder instanceof LayoutNotificationListItemHolder ? (LayoutNotificationListItemHolder)holder : null;
            if (((NotificationsListItem.Notification)item).getItem().getRead()) {
                Object object4 = viewHolder;
                FrameLayout frameLayout = object4 != null && (object4 = object4.getBinding()) != null ? ((LayoutNotificationListItemBinding)object4).unreadIndicatorFrameLayout : null;
                if (frameLayout != null) {
                    frameLayout.setVisibility(4);
                }
            } else {
                Object object5 = viewHolder;
                FrameLayout frameLayout = object5 != null && (object5 = object5.getBinding()) != null ? ((LayoutNotificationListItemBinding)object5).unreadIndicatorFrameLayout : null;
                if (frameLayout != null) {
                    frameLayout.setVisibility(0);
                }
            }
            TextView textView = (object3 = viewHolder) != null && (object3 = object3.getBinding()) != null ? ((LayoutNotificationListItemBinding)object3).titleTextView : null;
            if (textView != null) {
                textView.setText((CharSequence)((NotificationsListItem.Notification)item).getItem().getTitle());
            }
            TextView textView2 = (object2 = viewHolder) != null && (object2 = object2.getBinding()) != null ? ((LayoutNotificationListItemBinding)object2).subtitleTextView : null;
            if (textView2 != null) {
                textView2.setText((CharSequence)((NotificationsListItem.Notification)item).getItem().getSubtitle());
            }
            if ((object = viewHolder) != null && (object = object.getBinding()) != null && (object = ((LayoutNotificationListItemBinding)object).button) != null) {
                object.setOnClickListener(arg_0 -> NotificationsListAdapter.onBindViewHolder$lambda$0(this, item, arg_0));
            }
        }
    }

    public int getItemCount() {
        return ((Collection)this.data).size();
    }

    public final void updateData(@NotNull List<? extends NotificationsListItem> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
        this.notifyDataSetChanged();
    }

    private static final void onBindViewHolder$lambda$0(NotificationsListAdapter this$0, NotificationsListItem $item, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        this$0.onNotificationSelected.invoke((Object)$item);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/grovs/adapters/NotificationsListAdapter$NotificationSelectionItemTypes;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "ITEM", "Grovs_release"})
    public static final class NotificationSelectionItemTypes
    extends Enum<NotificationSelectionItemTypes> {
        private final int value;
        public static final /* enum */ NotificationSelectionItemTypes ITEM = new NotificationSelectionItemTypes(0);
        private static final /* synthetic */ NotificationSelectionItemTypes[] $VALUES;

        private NotificationSelectionItemTypes(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static NotificationSelectionItemTypes[] values() {
            return (NotificationSelectionItemTypes[])$VALUES.clone();
        }

        public static NotificationSelectionItemTypes valueOf(String value) {
            return Enum.valueOf(NotificationSelectionItemTypes.class, value);
        }

        static {
            $VALUES = notificationSelectionItemTypesArray = new NotificationSelectionItemTypes[]{NotificationSelectionItemTypes.ITEM};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/grovs/adapters/NotificationsListAdapter$LayoutNotificationListItemHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/grovs/databinding/LayoutNotificationListItemBinding;", "context", "Landroid/content/Context;", "(Lio/grovs/databinding/LayoutNotificationListItemBinding;Landroid/content/Context;)V", "getBinding", "()Lio/grovs/databinding/LayoutNotificationListItemBinding;", "getContext", "()Landroid/content/Context;", "Grovs_release"})
    public static final class LayoutNotificationListItemHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final LayoutNotificationListItemBinding binding;
        @NotNull
        private final Context context;

        public LayoutNotificationListItemHolder(@NotNull LayoutNotificationListItemBinding binding, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super((View)binding.getRoot());
            this.binding = binding;
            this.context = context;
        }

        @NotNull
        public final LayoutNotificationListItemBinding getBinding() {
            return this.binding;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }
    }
}

