/*
 * Decompiled with CFR 0.152.
 */
package io.grovs.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import io.grovs.model.AppDetails;
import io.grovs.utils.AppDetailsHelperKt;
import io.grovs.utils.WebViewUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cR\"\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR&\u0010\u000f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lio/grovs/utils/AppDetailsHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "applicationId", "", "kotlin.jvm.PlatformType", "getApplicationId", "()Ljava/lang/String;", "setApplicationId", "(Ljava/lang/String;)V", "device", "getDevice", "setDevice", "deviceID", "getDeviceID", "setDeviceID", "versionCode", "", "getVersionCode", "()I", "setVersionCode", "(I)V", "versionName", "getVersionName", "setVersionName", "toAppDetails", "Lio/grovs/model/AppDetails;", "Grovs_release"})
public final class AppDetailsHelper {
    @NotNull
    private final Context context;
    @NotNull
    private String versionName;
    private int versionCode;
    private String applicationId;
    @SuppressLint(value={"HardwareIds"})
    private String deviceID;
    @NotNull
    private String device;

    public AppDetailsHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        String string = this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageManager.g\u2026ckageName, 0).versionName");
        this.versionName = string;
        this.versionCode = this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionCode;
        this.applicationId = this.context.getPackageName();
        this.deviceID = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        this.device = AppDetailsHelperKt.getDeviceName();
    }

    @NotNull
    public final String getVersionName() {
        return this.versionName;
    }

    public final void setVersionName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.versionName = string;
    }

    public final int getVersionCode() {
        return this.versionCode;
    }

    public final void setVersionCode(int n) {
        this.versionCode = n;
    }

    public final String getApplicationId() {
        return this.applicationId;
    }

    public final void setApplicationId(String string) {
        this.applicationId = string;
    }

    public final String getDeviceID() {
        return this.deviceID;
    }

    public final void setDeviceID(String string) {
        this.deviceID = string;
    }

    @NotNull
    public final String getDevice() {
        return this.device;
    }

    public final void setDevice(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.device = string;
    }

    @NotNull
    public final AppDetails toAppDetails() {
        String string = String.valueOf(this.versionCode);
        String string2 = this.applicationId;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"applicationId");
        String string3 = this.deviceID;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"deviceID");
        return new AppDetails(this.versionName, string, string2, this.device, string3, WebViewUtils.Companion.getUserAgent(this.context), null, 64, null);
    }
}

