/*
 * Decompiled with CFR 0.152.
 */
package io.grovs.utils;

import io.grovs.utils.InstantCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\tH\u0016J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lio/grovs/utils/DurationCompat;", "", "millis", "", "(J)V", "seconds", "getSeconds", "()J", "compareTo", "", "other", "equals", "", "hashCode", "minus", "plus", "toDays", "toHours", "toMillis", "toMinutes", "toSeconds", "toString", "", "Companion", "Grovs_release"})
public final class DurationCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long millis;

    private DurationCompat(long millis) {
        this.millis = millis;
    }

    public final long getSeconds() {
        return this.millis / (long)1000;
    }

    public final long toMillis() {
        return this.millis;
    }

    public final long toSeconds() {
        return this.getSeconds();
    }

    public final long toMinutes() {
        return this.millis / (long)60000;
    }

    public final long toHours() {
        return this.millis / (long)3600000;
    }

    public final long toDays() {
        return this.millis / (long)86400000;
    }

    @NotNull
    public final DurationCompat plus(@NotNull DurationCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new DurationCompat(this.millis + other.millis);
    }

    @NotNull
    public final DurationCompat minus(@NotNull DurationCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new DurationCompat(this.millis - other.millis);
    }

    public final int compareTo(@NotNull DurationCompat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.millis, (long)other.millis);
    }

    @NotNull
    public String toString() {
        return this.toSeconds() + "s (" + this.millis + "ms)";
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DurationCompat && ((DurationCompat)other).millis == this.millis;
    }

    public int hashCode() {
        return Long.hashCode(this.millis);
    }

    public /* synthetic */ DurationCompat(long millis, DefaultConstructorMarker $constructor_marker) {
        this(millis);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Lio/grovs/utils/DurationCompat$Companion;", "", "()V", "between", "Lio/grovs/utils/DurationCompat;", "startInclusive", "Lio/grovs/utils/InstantCompat;", "endExclusive", "ofDays", "days", "", "ofHours", "hours", "ofMillis", "millis", "ofMinutes", "minutes", "ofSeconds", "seconds", "Grovs_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DurationCompat between(@NotNull InstantCompat startInclusive, @NotNull InstantCompat endExclusive) {
            Intrinsics.checkNotNullParameter((Object)startInclusive, (String)"startInclusive");
            Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
            return new DurationCompat(endExclusive.toEpochMilli() - startInclusive.toEpochMilli(), null);
        }

        @NotNull
        public final DurationCompat ofMillis(long millis) {
            return new DurationCompat(millis, null);
        }

        @NotNull
        public final DurationCompat ofSeconds(long seconds) {
            return new DurationCompat(seconds * (long)1000, null);
        }

        @NotNull
        public final DurationCompat ofMinutes(long minutes) {
            return new DurationCompat(minutes * (long)60 * (long)1000, null);
        }

        @NotNull
        public final DurationCompat ofHours(long hours) {
            return new DurationCompat(hours * (long)60 * (long)60 * (long)1000, null);
        }

        @NotNull
        public final DurationCompat ofDays(long days) {
            return new DurationCompat(days * (long)24 * (long)60 * (long)60 * (long)1000, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

