/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Attributes;
import io.grpc.ClientInterceptor;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.NameResolverRegistry;
import io.grpc.ResolvedServerInfo;
import io.grpc.SimpleLoadBalancerFactory;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.internal.ReferenceCounted;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends ManagedChannelBuilder<T> {
    private static final String DIRECT_ADDRESS_SCHEME = "directaddress";
    @Nullable
    private Executor executor;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private final String target;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    private String userAgent;
    @Nullable
    private String authorityOverride;
    @Nullable
    private NameResolver.Factory nameResolverFactory;
    @Nullable
    private LoadBalancer.Factory loadBalancerFactory;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;

    protected AbstractManagedChannelImplBuilder(String target) {
        this.target = (String)Preconditions.checkNotNull((Object)target);
        this.directServerAddress = null;
    }

    protected AbstractManagedChannelImplBuilder(SocketAddress directServerAddress, String authority) {
        this.target = "directaddress:///" + directServerAddress;
        this.directServerAddress = directServerAddress;
        this.nameResolverFactory = new DirectAddressNameResolverFactory(directServerAddress, authority);
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this.thisT();
    }

    @Override
    public final T intercept(ClientInterceptor ... interceptors) {
        return (T)this.intercept((List)Arrays.asList(interceptors));
    }

    @Override
    public final T nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of NameResolverFactory", (Object[])new Object[]{this.directServerAddress});
        this.nameResolverFactory = resolverFactory;
        return this.thisT();
    }

    @Override
    public final T loadBalancerFactory(LoadBalancer.Factory loadBalancerFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of LoadBalancerFactory", (Object[])new Object[]{this.directServerAddress});
        this.loadBalancerFactory = loadBalancerFactory;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    private T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }

    @Override
    public final T userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this.thisT();
    }

    @Override
    public final T overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this.thisT();
    }

    protected String checkAuthority(String authority) {
        return GrpcUtil.checkAuthority(authority);
    }

    @Override
    public ManagedChannelImpl build() {
        AuthorityOverridingTransportFactory transportFactory = new AuthorityOverridingTransportFactory(this.buildTransportFactory(), this.authorityOverride);
        return new ManagedChannelImpl(this.target, new ExponentialBackoffPolicy.Provider(), (NameResolver.Factory)MoreObjects.firstNonNull((Object)this.nameResolverFactory, (Object)NameResolverRegistry.getDefaultRegistry()), this.getNameResolverParams(), (LoadBalancer.Factory)MoreObjects.firstNonNull((Object)this.loadBalancerFactory, (Object)SimpleLoadBalancerFactory.getInstance()), transportFactory, (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), this.executor, this.userAgent, this.interceptors);
    }

    protected abstract ClientTransportFactory buildTransportFactory();

    protected Attributes getNameResolverParams() {
        return Attributes.EMPTY;
    }

    private static class DirectAddressNameResolverFactory
    extends NameResolver.Factory {
        final SocketAddress address;
        final String authority;

        DirectAddressNameResolverFactory(SocketAddress address, String authority) {
            this.address = address;
            this.authority = authority;
        }

        @Override
        public NameResolver newNameResolver(URI notUsedUri, Attributes params) {
            return new NameResolver(){

                @Override
                public String getServiceAuthority() {
                    return DirectAddressNameResolverFactory.this.authority;
                }

                @Override
                public void start(NameResolver.Listener listener) {
                    listener.onUpdate(Collections.singletonList(new ResolvedServerInfo(DirectAddressNameResolverFactory.this.address, Attributes.EMPTY)), Attributes.EMPTY);
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return AbstractManagedChannelImplBuilder.DIRECT_ADDRESS_SCHEME;
        }
    }

    private static class AuthorityOverridingTransportFactory
    implements ClientTransportFactory {
        final ClientTransportFactory factory;
        @Nullable
        final String authorityOverride;

        AuthorityOverridingTransportFactory(ClientTransportFactory factory, @Nullable String authorityOverride) {
            this.factory = factory;
            this.authorityOverride = authorityOverride;
        }

        @Override
        public ClientTransport newClientTransport(SocketAddress serverAddress, String authority) {
            return this.factory.newClientTransport(serverAddress, this.authorityOverride != null ? this.authorityOverride : authority);
        }

        @Override
        public int referenceCount() {
            return this.factory.referenceCount();
        }

        @Override
        public ReferenceCounted retain() {
            this.factory.retain();
            return this;
        }

        @Override
        public ReferenceCounted release() {
            this.factory.release();
            return this;
        }
    }
}

