/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.netty.NettyClientStream;
import java.util.EnumSet;

class CancelStreamCommand {
    private final NettyClientStream stream;
    private final Status reason;

    CancelStreamCommand(NettyClientStream stream, Status reason) {
        this.stream = (NettyClientStream)Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkNotNull((Object)reason);
        Preconditions.checkArgument((boolean)EnumSet.of(Status.Code.CANCELLED, Status.Code.DEADLINE_EXCEEDED).contains((Object)reason.getCode()), (Object)"Invalid cancellation reason");
        this.reason = reason;
    }

    NettyClientStream stream() {
        return this.stream;
    }

    Status reason() {
        return this.reason;
    }
}

