/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import io.grpc.inprocess.InProcessTransport;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractReferenceCounted;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ManagedClientTransport;
import java.net.SocketAddress;

public class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final String name;

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    private InProcessChannelBuilder(String name) {
        super(new InProcessSocketAddress(name), "localhost");
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public InProcessChannelBuilder usePlaintext(boolean skipNegotiation) {
        return this;
    }

    @Override
    protected ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.name);
    }

    private static class InProcessSocketAddress
    extends SocketAddress {
        final String name;

        InProcessSocketAddress(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class InProcessClientTransportFactory
    extends AbstractReferenceCounted
    implements ClientTransportFactory {
        private final String name;

        private InProcessClientTransportFactory(String name) {
            this.name = name;
        }

        @Override
        public ManagedClientTransport newClientTransport(SocketAddress addr, String authority) {
            return new InProcessTransport(this.name);
        }

        @Override
        protected void deallocate() {
        }
    }
}

