/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.concurrent.TimeUnit;

abstract class AbstractNettyHandler
extends Http2ConnectionHandler {
    private static long GRACEFUL_SHUTDOWN_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private int initialConnectionWindow;
    private ChannelHandlerContext ctx;

    AbstractNettyHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
        this.gracefulShutdownTimeoutMillis(GRACEFUL_SHUTDOWN_TIMEOUT);
        this.initialConnectionWindow = initialSettings.initialWindowSize() == null ? -1 : initialSettings.initialWindowSize();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        super.handlerAdded(ctx);
        this.sendInitialConnectionWindow();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.sendInitialConnectionWindow();
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Http2Exception embedded = Http2CodecUtil.getEmbeddedHttp2Exception((Throwable)cause);
        if (embedded == null) {
            String message = cause.getMessage() == null ? "Unknown error occurred" : cause.getMessage();
            cause = Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)cause, (String)message, (Object[])new Object[0]);
        }
        super.exceptionCaught(ctx, cause);
    }

    protected final ChannelHandlerContext ctx() {
        return this.ctx;
    }

    private void sendInitialConnectionWindow() throws Http2Exception {
        if (this.ctx.channel().isActive() && this.initialConnectionWindow > 0) {
            Http2Stream connectionStream = this.connection().connectionStream();
            int currentSize = ((Http2LocalFlowController)this.connection().local().flowController()).windowSize(connectionStream);
            int delta = this.initialConnectionWindow - currentSize;
            this.decoder().flowController().incrementWindowSize(connectionStream, delta);
            this.initialConnectionWindow = -1;
            this.ctx.flush();
        }
    }
}

