/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.netty.NettyClientHandler;
import io.grpc.netty.NettyClientStream;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.SendPingCommand;
import io.grpc.netty.Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class NettyClientTransport
implements ManagedClientTransport {
    private final SocketAddress address;
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final AsciiString authority;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private ProtocolNegotiator.Handler negotiationHandler;
    private NettyClientHandler handler;
    private Channel channel;
    private ManagedClientTransport.Listener listener;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;

    NettyClientTransport(SocketAddress address, Class<? extends Channel> channelType, EventLoopGroup group, ProtocolNegotiator negotiator, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, String authority) {
        this.negotiator = (ProtocolNegotiator)Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        this.address = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.group = (EventLoopGroup)Preconditions.checkNotNull((Object)group, (Object)"group");
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.authority = new AsciiString((CharSequence)authority);
    }

    @Override
    public void ping(ClientTransport.PingCallback callback, Executor executor) {
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        return new NettyClientStream(method, headers, this.channel, this.handler, this.maxMessageSize, this.authority, this.negotiationHandler.scheme());
    }

    @Override
    public void start(ManagedClientTransport.Listener transportListener) {
        this.listener = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)transportListener, (Object)"listener");
        this.handler = this.newHandler();
        this.negotiationHandler = this.negotiator.newHandler(this.handler);
        Bootstrap b = new Bootstrap();
        b.group(this.group);
        b.channel(this.channelType);
        if (NioSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        b.handler((ChannelHandler)this.negotiationHandler);
        this.channel = b.connect(this.address).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ChannelHandlerContext ctx = NettyClientTransport.this.channel.pipeline().context((ChannelHandler)NettyClientTransport.this.handler);
                    if (ctx != null) {
                        ctx.fireExceptionCaught(future.cause());
                    }
                    NettyClientTransport.this.channel.pipeline().fireExceptionCaught(future.cause());
                }
            }
        }).channel();
        this.handler.startWriteQueue(this.channel);
        this.channel.write(NettyClientHandler.NOOP_MESSAGE).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.notifyTerminated(Utils.statusFromThrowable(future.cause()));
                }
            }
        });
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Status status = NettyClientTransport.this.handler.errorStatus();
                if (status == null) {
                    status = Status.INTERNAL.withDescription("Connection closed with unknown cause");
                }
                NettyClientTransport.this.notifyTerminated(status);
            }
        });
    }

    @Override
    public void shutdown() {
        this.notifyShutdown(Status.OK.withDescription("Channel requested transport to shut down"));
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }

    public String toString() {
        return super.toString() + "(" + this.address + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdown(Status status) {
        boolean notifyShutdown;
        Preconditions.checkNotNull((Object)status, (Object)"status");
        NettyClientTransport nettyClientTransport = this;
        synchronized (nettyClientTransport) {
            notifyShutdown = !this.shutdown;
            this.shutdown = true;
        }
        if (notifyShutdown) {
            this.listener.transportShutdown(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTerminated(Status status) {
        boolean notifyTerminated;
        this.notifyShutdown(status);
        NettyClientTransport nettyClientTransport = this;
        synchronized (nettyClientTransport) {
            notifyTerminated = !this.terminated;
            this.terminated = true;
        }
        if (notifyTerminated) {
            this.listener.transportTerminated();
        }
    }

    private NettyClientHandler newHandler() {
        return NettyClientHandler.newHandler(this.listener, this.flowControlWindow, this.maxHeaderListSize, Ticker.systemTicker());
    }
}

