/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.google.common.base.Preconditions;
import com.squareup.okhttp.Address;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.Platform;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class OkHttpTlsUpgrader {
    private static final List<String> SUPPORTED_HTTP2_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("h2", "h2-14", "h2-15", "h2-16"));
    private static final InetSocketAddress DUMMY_INET_SOCKET_ADDRESS = InetSocketAddress.createUnresolved("fake", 73);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocket upgrade(SSLSocketFactory sslSocketFactory, Socket socket, String host, int port, ConnectionSpec spec) throws IOException {
        Preconditions.checkNotNull((Object)sslSocketFactory);
        Preconditions.checkNotNull((Object)socket);
        Preconditions.checkNotNull((Object)spec);
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, host, port, true);
        spec.apply(sslSocket, OkHttpTlsUpgrader.getOkHttpRoute(host, port, spec));
        Platform platform = Platform.get();
        String negotiatedProtocol = null;
        try {
            negotiatedProtocol = platform.getSelectedProtocol(sslSocket);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (negotiatedProtocol == null) {
            try {
                sslSocket.startHandshake();
                negotiatedProtocol = platform.getSelectedProtocol(sslSocket);
                if (negotiatedProtocol == null) {
                    throw new RuntimeException("protocol negotiation failed");
                }
            }
            finally {
                platform.afterHandshake(sslSocket);
            }
        }
        Preconditions.checkState((boolean)SUPPORTED_HTTP2_PROTOCOLS.contains(negotiatedProtocol), (String)"negotiated protocol %s is unsupported", (Object[])new Object[]{negotiatedProtocol});
        return sslSocket;
    }

    private static Route getOkHttpRoute(String host, int port, ConnectionSpec spec) {
        return new Route(OkHttpTlsUpgrader.getOkHttpAddress(host, port), Proxy.NO_PROXY, DUMMY_INET_SOCKET_ADDRESS, spec);
    }

    private static Address getOkHttpAddress(String host, int port) {
        return new Address(host, port, null, null, null, null, (Authenticator)DummyAuthenticator.INSTANCE, Proxy.NO_PROXY, Arrays.asList(Protocol.HTTP_2), Collections.emptyList(), ProxySelector.getDefault());
    }

    private static class DummyAuthenticator
    implements Authenticator {
        static final DummyAuthenticator INSTANCE = new DummyAuthenticator();

        private DummyAuthenticator() {
        }

        public Request authenticate(Proxy proxy, Response response) throws IOException {
            return null;
        }

        public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
            return null;
        }
    }
}

