/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.grpc.Call;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.MethodType;
import io.grpc.SerializingExecutor;
import io.grpc.Status;
import io.grpc.transport.ClientStream;
import io.grpc.transport.ClientStreamListener;
import io.grpc.transport.ClientTransport;
import io.grpc.transport.ClientTransportFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ChannelImpl
extends Channel {
    private static final Logger log = Logger.getLogger(ChannelImpl.class.getName());
    private final ClientTransportFactory transportFactory;
    private final ExecutorService executor;
    @GuardedBy(value="this")
    private Collection<ClientTransport> transports = new ArrayList<ClientTransport>();
    @GuardedBy(value="this")
    private ClientTransport activeTransport;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;
    private Runnable terminationRunnable;

    public ChannelImpl(ClientTransportFactory transportFactory, ExecutorService executor) {
        this.transportFactory = transportFactory;
        this.executor = executor;
    }

    void setTerminationRunnable(Runnable runnable) {
        this.terminationRunnable = runnable;
    }

    public synchronized ChannelImpl shutdown() {
        if (this.shutdown) {
            return this;
        }
        this.shutdown = true;
        if (this.activeTransport != null) {
            this.activeTransport.shutdown();
            this.activeTransport = null;
        } else if (this.transports.isEmpty()) {
            this.terminated = true;
            this.notifyAll();
            if (this.terminationRunnable != null) {
                this.terminationRunnable.run();
            }
        }
        return this;
    }

    public synchronized ChannelImpl shutdownNow() {
        this.shutdown();
        return this;
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    public synchronized boolean awaitTerminated(long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutNanos = unit.toNanos(timeout);
        long endTimeNanos = System.nanoTime() + timeoutNanos;
        while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
            TimeUnit.NANOSECONDS.timedWait(this, timeoutNanos);
        }
        return this.terminated;
    }

    public synchronized boolean isTerminated() {
        return this.terminated;
    }

    public <ReqT, RespT> Call<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method) {
        return new CallImpl<ReqT, RespT>(method, new SerializingExecutor(this.executor));
    }

    private synchronized ClientTransport obtainActiveTransport() {
        if (this.shutdown) {
            return null;
        }
        if (this.activeTransport != null) {
            return this.activeTransport;
        }
        this.activeTransport = this.transportFactory.newClientTransport();
        this.transports.add(this.activeTransport);
        try {
            this.activeTransport.start(new TransportListener(this.activeTransport));
        }
        catch (RuntimeException ex) {
            this.transports.remove(this.activeTransport);
            this.activeTransport = null;
            throw ex;
        }
        return this.activeTransport;
    }

    private class CallImpl<ReqT, RespT>
    extends Call<ReqT, RespT> {
        private final MethodDescriptor<ReqT, RespT> method;
        private final SerializingExecutor callExecutor;
        private final boolean unaryRequest;
        private ClientStream stream;

        public CallImpl(MethodDescriptor<ReqT, RespT> method, SerializingExecutor executor) {
            this.method = method;
            this.callExecutor = executor;
            this.unaryRequest = method.getType() == MethodType.UNARY || method.getType() == MethodType.SERVER_STREAMING;
        }

        @Override
        public void start(Call.Listener<RespT> observer, Metadata.Headers headers) {
            ClientTransport transport;
            Preconditions.checkState((this.stream == null ? 1 : 0) != 0, (Object)"Already started");
            ClientStreamListenerImpl listener = new ClientStreamListenerImpl(observer);
            try {
                transport = ChannelImpl.this.obtainActiveTransport();
            }
            catch (RuntimeException ex) {
                this.stream = new NoopClientStream();
                listener.closed(Status.INTERNAL.withDescription("Failed starting transport").withCause(ex), new Metadata.Trailers());
                return;
            }
            if (transport == null) {
                this.stream = new NoopClientStream();
                listener.closed(Status.CANCELLED.withDescription("Channel is shutdown"), new Metadata.Trailers());
                return;
            }
            try {
                this.stream = transport.newStream(this.method, headers, listener);
            }
            catch (IllegalStateException ex) {
                this.stream = new NoopClientStream();
                listener.closed(Status.fromThrowable(ex), new Metadata.Trailers());
                return;
            }
        }

        @Override
        public void request(int numMessages) {
            Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
            this.stream.request(numMessages);
        }

        @Override
        public void cancel() {
            if (this.stream != null) {
                this.stream.cancel();
            }
        }

        @Override
        public void halfClose() {
            Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
            this.stream.halfClose();
        }

        private int available(InputStream is) {
            try {
                return is.available();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendPayload(ReqT payload) {
            Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"Not started");
            boolean failed = true;
            try {
                InputStream payloadIs = this.method.streamRequest(payload);
                this.stream.writeMessage(payloadIs, this.available(payloadIs));
                failed = false;
            }
            finally {
                if (failed) {
                    this.cancel();
                }
            }
            if (!this.unaryRequest) {
                this.stream.flush();
            }
        }

        @Override
        public boolean isReady() {
            return this.stream.isReady();
        }

        private class ClientStreamListenerImpl
        implements ClientStreamListener {
            private final Call.Listener<RespT> observer;
            private boolean closed;

            public ClientStreamListenerImpl(Call.Listener<RespT> observer) {
                Preconditions.checkNotNull(observer);
                this.observer = observer;
            }

            @Override
            public void headersRead(final Metadata.Headers headers) {
                CallImpl.this.callExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ClientStreamListenerImpl.this.closed) {
                                return;
                            }
                            ClientStreamListenerImpl.this.observer.onHeaders(headers);
                        }
                        catch (Throwable t) {
                            CallImpl.this.cancel();
                            throw Throwables.propagate((Throwable)t);
                        }
                    }
                });
            }

            @Override
            public void messageRead(final InputStream message) {
                CallImpl.this.callExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ClientStreamListenerImpl.this.closed) {
                                return;
                            }
                            try {
                                ClientStreamListenerImpl.this.observer.onPayload(CallImpl.this.method.parseResponse(message));
                            }
                            finally {
                                message.close();
                            }
                        }
                        catch (Throwable t) {
                            CallImpl.this.cancel();
                            throw Throwables.propagate((Throwable)t);
                        }
                    }
                });
            }

            @Override
            public void closed(final Status status, final Metadata.Trailers trailers) {
                CallImpl.this.callExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ClientStreamListenerImpl.this.closed = true;
                        ClientStreamListenerImpl.this.observer.onClose(status, trailers);
                    }
                });
            }

            @Override
            public void onReady() {
                CallImpl.this.callExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ClientStreamListenerImpl.this.observer.onReady();
                    }
                });
            }
        }
    }

    private class TransportListener
    implements ClientTransport.Listener {
        private final ClientTransport transport;

        public TransportListener(ClientTransport transport) {
            this.transport = transport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportShutdown() {
            ChannelImpl channelImpl = ChannelImpl.this;
            synchronized (channelImpl) {
                if (ChannelImpl.this.activeTransport == this.transport) {
                    ChannelImpl.this.activeTransport = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportTerminated() {
            ChannelImpl channelImpl = ChannelImpl.this;
            synchronized (channelImpl) {
                if (ChannelImpl.this.activeTransport == this.transport) {
                    log.warning("transportTerminated called without previous transportShutdown");
                    ChannelImpl.this.activeTransport = null;
                }
                this.transportShutdown();
                ChannelImpl.this.transports.remove(this.transport);
                if (ChannelImpl.this.shutdown && ChannelImpl.this.transports.isEmpty()) {
                    if (ChannelImpl.this.terminated) {
                        log.warning("transportTerminated called after already terminated");
                    }
                    ChannelImpl.this.terminated = true;
                    ChannelImpl.this.notifyAll();
                    if (ChannelImpl.this.terminationRunnable != null) {
                        ChannelImpl.this.terminationRunnable.run();
                    }
                }
            }
        }
    }

    private static class NoopClientStream
    implements ClientStream {
        private NoopClientStream() {
        }

        @Override
        public void writeMessage(InputStream message, int length) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void halfClose() {
        }

        @Override
        public void request(int numMessages) {
        }

        @Override
        public boolean isReady() {
            return false;
        }
    }
}

