/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.nano;

import com.google.common.io.ByteStreams;
import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.MessageNano;
import io.grpc.Marshaller;
import io.grpc.Status;
import io.grpc.protobuf.nano.DeferredNanoProtoInputStream;
import io.grpc.protobuf.nano.Parser;
import java.io.IOException;
import java.io.InputStream;

public class NanoUtils {
    private NanoUtils() {
    }

    public static <T extends MessageNano> Marshaller<T> marshaller(final Parser<T> parser) {
        return new Marshaller<T>(){

            @Override
            public InputStream stream(T value) {
                return new DeferredNanoProtoInputStream((MessageNano)value);
            }

            @Override
            public T parse(InputStream stream) {
                try {
                    CodedInputByteBufferNano input = CodedInputByteBufferNano.newInstance((byte[])ByteStreams.toByteArray((InputStream)stream));
                    return parser.parse(input);
                }
                catch (IOException ipbe) {
                    throw Status.INTERNAL.withDescription("Failed parsing nano proto message").withCause(ipbe).asRuntimeException();
                }
            }
        };
    }
}

