/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.netty;

import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.transport.ClientStream;
import io.grpc.transport.ClientStreamListener;
import io.grpc.transport.ClientTransport;
import io.grpc.transport.netty.BufferingHttp2ConnectionEncoder;
import io.grpc.transport.netty.CreateStreamCommand;
import io.grpc.transport.netty.NettyClientHandler;
import io.grpc.transport.netty.NettyClientStream;
import io.grpc.transport.netty.ProtocolNegotiator;
import io.grpc.transport.netty.Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.util.AsciiString;
import io.netty.util.ByteString;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

class NettyClientTransport
implements ClientTransport {
    private static final Logger log = Logger.getLogger(NettyClientTransport.class.getName());
    private final SocketAddress address;
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup group;
    private final ProtocolNegotiator.Handler negotiationHandler;
    private final NettyClientHandler handler;
    private final AsciiString authority;
    private final int connectionWindowSize;
    private final int streamWindowSize;
    private Channel channel;
    private ClientTransport.Listener listener;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;

    NettyClientTransport(SocketAddress address, Class<? extends Channel> channelType, EventLoopGroup group, ProtocolNegotiator negotiator, int connectionWindowSize, int streamWindowSize) {
        Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        this.address = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.group = (EventLoopGroup)Preconditions.checkNotNull((Object)group, (Object)"group");
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        this.connectionWindowSize = connectionWindowSize;
        this.streamWindowSize = streamWindowSize;
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            this.authority = new AsciiString((CharSequence)(inetAddress.getHostString() + ":" + inetAddress.getPort()));
        } else {
            this.authority = new AsciiString((CharSequence)address.toString());
        }
        this.handler = this.newHandler();
        this.negotiationHandler = negotiator.newHandler(this.handler);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata.Headers headers, ClientStreamListener listener) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        NettyClientStream stream = new NettyClientStream(listener, this.channel, this.handler);
        AsciiString defaultPath = new AsciiString((CharSequence)("/" + method.getName()));
        Http2Headers http2Headers = Utils.convertClientHeaders(headers, this.negotiationHandler.scheme(), (ByteString)defaultPath, (ByteString)this.authority);
        this.handler.getWriteQueue().enqueue(new CreateStreamCommand(http2Headers, stream), !method.getType().clientSendsOneMessage());
        return stream;
    }

    @Override
    public void start(ClientTransport.Listener transportListener) {
        this.listener = (ClientTransport.Listener)Preconditions.checkNotNull((Object)transportListener, (Object)"listener");
        Bootstrap b = new Bootstrap();
        b.group(this.group);
        b.channel(this.channelType);
        if (NioSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        b.handler((ChannelHandler)this.negotiationHandler);
        this.channel = b.connect(this.address).channel();
        this.handler.startWriteQueue(this.channel);
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.notifyTerminated(future.cause());
                    return;
                }
                if (NettyClientTransport.this.handler.connectionError() != null) {
                    NettyClientTransport.this.notifyTerminated(NettyClientTransport.this.handler.connectionError());
                } else {
                    NettyClientTransport.this.notifyTerminated(null);
                }
            }
        });
    }

    @Override
    public void shutdown() {
        this.notifyShutdown(null);
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdown(Throwable t) {
        boolean notifyShutdown;
        if (t != null) {
            log.log(Level.SEVERE, "Transport failed", t);
        }
        NettyClientTransport nettyClientTransport = this;
        synchronized (nettyClientTransport) {
            boolean bl = notifyShutdown = !this.shutdown;
            if (!this.shutdown) {
                this.shutdown = true;
            }
        }
        if (notifyShutdown) {
            this.listener.transportShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTerminated(Throwable t) {
        boolean notifyTerminated;
        this.notifyShutdown(t);
        NettyClientTransport nettyClientTransport = this;
        synchronized (nettyClientTransport) {
            notifyTerminated = !this.terminated;
            this.terminated = true;
        }
        if (notifyTerminated) {
            this.listener.transportTerminated();
        }
    }

    private NettyClientHandler newHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        DefaultHttp2FrameReader frameReader = new DefaultHttp2FrameReader();
        DefaultHttp2FrameWriter frameWriter = new DefaultHttp2FrameWriter();
        Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.DEBUG, this.getClass());
        frameReader = new Http2InboundFrameLogger((Http2FrameReader)frameReader, frameLogger);
        frameWriter = new Http2OutboundFrameLogger((Http2FrameWriter)frameWriter, frameLogger);
        BufferingHttp2ConnectionEncoder encoder = new BufferingHttp2ConnectionEncoder((Http2ConnectionEncoder)new DefaultHttp2ConnectionEncoder((Http2Connection)connection, (Http2FrameWriter)frameWriter));
        return new NettyClientHandler(encoder, (Http2Connection)connection, (Http2FrameReader)frameReader, this.connectionWindowSize, this.streamWindowSize);
    }
}

