/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.okhttp;

import com.google.common.util.concurrent.SettableFuture;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameWriter;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.Settings;
import io.grpc.SerializingExecutor;
import io.grpc.transport.okhttp.OkHttpClientTransport;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import okio.Buffer;

class AsyncFrameWriter
implements FrameWriter {
    private final FrameWriter frameWriter;
    private final Executor executor;
    private final OkHttpClientTransport transport;

    public AsyncFrameWriter(FrameWriter frameWriter, OkHttpClientTransport transport, Executor executor) {
        this.frameWriter = frameWriter;
        this.transport = transport;
        this.executor = new SerializingExecutor(executor);
    }

    public void connectionPreface() {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.connectionPreface();
            }
        });
    }

    public void ackSettings(final Settings peerSettings) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.ackSettings(peerSettings);
            }
        });
    }

    public void pushPromise(final int streamId, final int promisedStreamId, final List<Header> requestHeaders) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.pushPromise(streamId, promisedStreamId, requestHeaders);
            }
        });
    }

    public void flush() {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.flush();
            }
        });
    }

    public void synStream(final boolean outFinished, final boolean inFinished, final int streamId, final int associatedStreamId, final List<Header> headerBlock) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.synStream(outFinished, inFinished, streamId, associatedStreamId, headerBlock);
            }
        });
    }

    public void synReply(final boolean outFinished, final int streamId, final List<Header> headerBlock) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.synReply(outFinished, streamId, headerBlock);
            }
        });
    }

    public void headers(final int streamId, final List<Header> headerBlock) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.headers(streamId, headerBlock);
            }
        });
    }

    public void rstStream(final int streamId, final ErrorCode errorCode) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.rstStream(streamId, errorCode);
            }
        });
    }

    public void data(final boolean outFinished, final int streamId, final Buffer source, final int byteCount) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.data(outFinished, streamId, source, byteCount);
            }
        });
    }

    public void settings(final Settings okHttpSettings) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.settings(okHttpSettings);
            }
        });
    }

    public void ping(final boolean ack, final int payload1, final int payload2) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.ping(ack, payload1, payload2);
            }
        });
    }

    public void goAway(final int lastGoodStreamId, final ErrorCode errorCode, final byte[] debugData) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.goAway(lastGoodStreamId, errorCode, debugData);
                AsyncFrameWriter.this.frameWriter.flush();
            }
        });
    }

    public void windowUpdate(final int streamId, final long windowSizeIncrement) {
        this.executor.execute(new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.windowUpdate(streamId, windowSizeIncrement);
            }
        });
    }

    public void close() {
        final SettableFuture closeFuture = SettableFuture.create();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncFrameWriter.this.frameWriter.close();
                }
                catch (IOException e) {
                    closeFuture.setException((Throwable)e);
                }
                finally {
                    closeFuture.set(null);
                }
            }
        });
        try {
            closeFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public int maxDataLength() {
        return this.frameWriter.maxDataLength();
    }

    private abstract class WriteRunnable
    implements Runnable {
        private WriteRunnable() {
        }

        @Override
        public final void run() {
            try {
                this.doRun();
            }
            catch (IOException ex) {
                AsyncFrameWriter.this.transport.onIoException(ex);
                throw new RuntimeException(ex);
            }
        }

        public abstract void doRun() throws IOException;
    }
}

