/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.okhttp;

import com.google.common.base.Preconditions;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.Header;
import io.grpc.Metadata;
import io.grpc.MethodType;
import io.grpc.Status;
import io.grpc.transport.ClientStreamListener;
import io.grpc.transport.Http2ClientStream;
import io.grpc.transport.WritableBuffer;
import io.grpc.transport.okhttp.AsyncFrameWriter;
import io.grpc.transport.okhttp.OkHttpClientTransport;
import io.grpc.transport.okhttp.OkHttpReadableBuffer;
import io.grpc.transport.okhttp.OkHttpWritableBuffer;
import io.grpc.transport.okhttp.OkHttpWritableBufferAllocator;
import io.grpc.transport.okhttp.OutboundFlowController;
import io.grpc.transport.okhttp.Utils;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import okio.Buffer;

class OkHttpClientStream
extends Http2ClientStream {
    private static int WINDOW_UPDATE_THRESHOLD = 32768;
    private static final Buffer EMPTY_BUFFER = new Buffer();
    private final MethodType type;
    @GuardedBy(value="lock")
    private int window = 65536;
    @GuardedBy(value="lock")
    private int processedWindow = 65536;
    private final AsyncFrameWriter frameWriter;
    private final OutboundFlowController outboundFlow;
    private final OkHttpClientTransport transport;
    private final Object lock = new Object();
    private Object outboundFlowState;
    private volatile Integer id;

    static OkHttpClientStream newStream(ClientStreamListener listener, AsyncFrameWriter frameWriter, OkHttpClientTransport transport, OutboundFlowController outboundFlow, MethodType type) {
        return new OkHttpClientStream(listener, frameWriter, transport, outboundFlow, type);
    }

    private OkHttpClientStream(ClientStreamListener listener, AsyncFrameWriter frameWriter, OkHttpClientTransport transport, OutboundFlowController outboundFlow, MethodType type) {
        super(new OkHttpWritableBufferAllocator(), listener);
        this.frameWriter = frameWriter;
        this.transport = transport;
        this.outboundFlow = outboundFlow;
        this.type = type;
    }

    public MethodType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(int numMessages) {
        Object object = this.lock;
        synchronized (object) {
            this.requestMessagesFromDeframer(numMessages);
        }
    }

    @Override
    @Nullable
    public Integer id() {
        return this.id;
    }

    public void id(Integer id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkState((this.id == null ? 1 : 0) != 0, (Object)"Can only set id once");
        this.id = id;
    }

    public void allocated() {
        this.onStreamAllocated();
    }

    void onStreamSentBytes(int numBytes) {
        this.onSentBytes(numBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transportHeadersReceived(List<Header> headers, boolean endOfStream) {
        Object object = this.lock;
        synchronized (object) {
            if (endOfStream) {
                this.transportTrailersReceived(Utils.convertTrailers(headers));
            } else {
                this.transportHeadersReceived(Utils.convertHeaders(headers));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transportDataReceived(Buffer frame, boolean endOfStream) {
        Object object = this.lock;
        synchronized (object) {
            long length = frame.size();
            this.window = (int)((long)this.window - length);
            if (this.window < 0) {
                this.frameWriter.rstStream(this.id(), ErrorCode.FLOW_CONTROL_ERROR);
                Status status = Status.INTERNAL.withDescription("Received data size exceeded our receiving window size");
                this.transport.finishStream(this.id(), status, null);
                return;
            }
            super.transportDataReceived(new OkHttpReadableBuffer(frame), endOfStream);
        }
    }

    @Override
    protected void sendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        Buffer buffer;
        Preconditions.checkState((this.id() != 0 ? 1 : 0) != 0, (Object)"streamId should be set");
        if (frame == null) {
            buffer = EMPTY_BUFFER;
        } else {
            buffer = ((OkHttpWritableBuffer)frame).buffer();
            int size = (int)buffer.size();
            if (size > 0) {
                this.onSendingBytes(size);
            }
        }
        this.outboundFlow.data(endOfStream, this.id(), buffer, flush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void returnProcessedBytes(int processedBytes) {
        Object object = this.lock;
        synchronized (object) {
            this.processedWindow -= processedBytes;
            if (this.processedWindow <= WINDOW_UPDATE_THRESHOLD) {
                int delta = 65536 - this.processedWindow;
                this.window += delta;
                this.processedWindow += delta;
                this.frameWriter.windowUpdate(this.id(), delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportReportStatus(Status newStatus, boolean stopDelivery, Metadata.Trailers trailers) {
        Object object = this.lock;
        synchronized (object) {
            super.transportReportStatus(newStatus, stopDelivery, trailers);
        }
    }

    @Override
    protected void sendCancel() {
        this.transport.finishStream(this.id(), Status.CANCELLED, ErrorCode.CANCEL);
    }

    @Override
    public void remoteEndClosed() {
        super.remoteEndClosed();
        if (this.canSend()) {
            this.frameWriter.rstStream(this.id(), ErrorCode.CANCEL);
        }
        this.transport.finishStream(this.id(), null, null);
    }

    void setOutboundFlowState(Object outboundFlowState) {
        this.outboundFlowState = outboundFlowState;
    }

    Object getOutboundFlowState() {
        return this.outboundFlowState;
    }
}

