/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.netty;

import com.google.common.base.Preconditions;
import io.grpc.AbstractServerBuilder;
import io.grpc.HandlerRegistry;
import io.grpc.SharedResourceHolder;
import io.grpc.transport.netty.NettyServer;
import io.grpc.transport.netty.Utils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class NettyServerBuilder
extends AbstractServerBuilder<NettyServerBuilder> {
    public static final int DEFAULT_CONNECTION_WINDOW_SIZE = 0x100000;
    public static final int DEFAULT_STREAM_WINDOW_SIZE = 65535;
    private final SocketAddress address;
    private Class<? extends ServerChannel> channelType = NioServerSocketChannel.class;
    private EventLoopGroup userBossEventLoopGroup;
    private EventLoopGroup userWorkerEventLoopGroup;
    private SslContext sslContext;
    private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
    private int connectionWindowSize = 0x100000;
    private int streamWindowSize = 65535;

    public static NettyServerBuilder forPort(int port) {
        return new NettyServerBuilder(port);
    }

    public static NettyServerBuilder forRegistryAndPort(HandlerRegistry registry, int port) {
        return new NettyServerBuilder(registry, port);
    }

    public static NettyServerBuilder forAddress(SocketAddress address) {
        return new NettyServerBuilder(address);
    }

    private NettyServerBuilder(int port) {
        this.address = new InetSocketAddress(port);
    }

    private NettyServerBuilder(HandlerRegistry registry, int port) {
        super(registry);
        this.address = new InetSocketAddress(port);
    }

    private NettyServerBuilder(SocketAddress address) {
        this.address = address;
    }

    public NettyServerBuilder channelType(Class<? extends ServerChannel> channelType) {
        this.channelType = (Class)Preconditions.checkNotNull(channelType);
        return this;
    }

    public NettyServerBuilder bossEventLoopGroup(EventLoopGroup group) {
        this.userBossEventLoopGroup = group;
        return this;
    }

    public NettyServerBuilder workerEventLoopGroup(EventLoopGroup group) {
        this.userWorkerEventLoopGroup = group;
        return this;
    }

    public NettyServerBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public NettyServerBuilder maxConcurrentCallsPerConnection(int maxCalls) {
        Preconditions.checkArgument((maxCalls > 0 ? 1 : 0) != 0, (String)"max must be positive: %s", (Object[])new Object[]{maxCalls});
        this.maxConcurrentCallsPerConnection = maxCalls;
        return this;
    }

    public NettyServerBuilder connectionWindowSize(int connectionWindowSize) {
        Preconditions.checkArgument((connectionWindowSize > 0 ? 1 : 0) != 0, (Object)"connectionWindowSize must be positive");
        this.connectionWindowSize = connectionWindowSize;
        return this;
    }

    public NettyServerBuilder streamWindowSize(int streamWindowSize) {
        Preconditions.checkArgument((streamWindowSize > 0 ? 1 : 0) != 0, (Object)"streamWindowSize must be positive");
        this.streamWindowSize = streamWindowSize;
        return this;
    }

    @Override
    protected AbstractServerBuilder.ServerEssentials buildEssentials() {
        final EventLoopGroup bossEventLoopGroup = this.userBossEventLoopGroup == null ? SharedResourceHolder.get(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP) : this.userBossEventLoopGroup;
        final EventLoopGroup workerEventLoopGroup = this.userWorkerEventLoopGroup == null ? SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP) : this.userWorkerEventLoopGroup;
        NettyServer server = new NettyServer(this.address, this.channelType, bossEventLoopGroup, workerEventLoopGroup, this.sslContext, this.maxConcurrentCallsPerConnection, this.connectionWindowSize, this.streamWindowSize);
        Runnable terminationRunnable = new Runnable(){

            @Override
            public void run() {
                if (NettyServerBuilder.this.userBossEventLoopGroup == null) {
                    SharedResourceHolder.release(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP, bossEventLoopGroup);
                }
                if (NettyServerBuilder.this.userWorkerEventLoopGroup == null) {
                    SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, workerEventLoopGroup);
                }
            }
        };
        return new AbstractServerBuilder.ServerEssentials(server, terminationRunnable);
    }
}

