/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.ChannelImpl;
import io.grpc.ClientInterceptor;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.SharedResourceHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public abstract class AbstractChannelBuilder<BuilderT extends AbstractChannelBuilder<BuilderT>> {
    static final SharedResourceHolder.Resource<ExecutorService> DEFAULT_EXECUTOR = new SharedResourceHolder.Resource<ExecutorService>(){
        private static final String name = "grpc-default-executor";

        @Override
        public ExecutorService create() {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("grpc-default-executor-%d").build());
        }

        @Override
        public void close(ExecutorService instance) {
            instance.shutdown();
        }

        public String toString() {
            return name;
        }
    };
    @Nullable
    private ExecutorService userExecutor;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    @Nullable
    private String userAgent;

    public final BuilderT executor(ExecutorService executor) {
        this.userExecutor = executor;
        return this.thisT();
    }

    public final BuilderT intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this.thisT();
    }

    public final BuilderT intercept(ClientInterceptor ... interceptors) {
        return this.intercept(Arrays.asList(interceptors));
    }

    private BuilderT thisT() {
        AbstractChannelBuilder thisT = this;
        return (BuilderT)thisT;
    }

    public final BuilderT userAgent(String userAgent) {
        this.userAgent = userAgent;
        return (BuilderT)this;
    }

    public ChannelImpl build() {
        boolean releaseExecutor;
        ExecutorService executor;
        if (this.userExecutor != null) {
            executor = this.userExecutor;
            releaseExecutor = false;
        } else {
            executor = SharedResourceHolder.get(DEFAULT_EXECUTOR);
            releaseExecutor = true;
        }
        final ChannelEssentials essentials = this.buildEssentials();
        ChannelImpl channel = new ChannelImpl(essentials.transportFactory, executor, this.userAgent, this.interceptors);
        channel.setTerminationRunnable(new Runnable(){

            @Override
            public void run() {
                if (releaseExecutor) {
                    SharedResourceHolder.release(DEFAULT_EXECUTOR, executor);
                }
                if (essentials.terminationRunnable != null) {
                    essentials.terminationRunnable.run();
                }
            }
        });
        return channel;
    }

    protected abstract ChannelEssentials buildEssentials();

    protected static class ChannelEssentials {
        final ClientTransportFactory transportFactory;
        @Nullable
        final Runnable terminationRunnable;

        public ChannelEssentials(ClientTransportFactory transportFactory, @Nullable Runnable terminationRunnable) {
            this.transportFactory = (ClientTransportFactory)Preconditions.checkNotNull((Object)transportFactory);
            this.terminationRunnable = terminationRunnable;
        }
    }
}

