/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.auth;

import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ClientAuthInterceptor
implements ClientInterceptor {
    private final Credentials credentials;
    private Metadata.Headers cached;
    private Map<String, List<String>> lastMetadata;
    private Executor executor;

    public ClientAuthInterceptor(Credentials credentials, Executor executor) {
        this.credentials = (Credentials)Preconditions.checkNotNull((Object)credentials);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata.Headers headers) throws Exception {
                Metadata.Headers cachedSaved;
                ClientAuthInterceptor clientAuthInterceptor = ClientAuthInterceptor.this;
                synchronized (clientAuthInterceptor) {
                    if (ClientAuthInterceptor.this.lastMetadata == null || ClientAuthInterceptor.this.lastMetadata != ClientAuthInterceptor.this.credentials.getRequestMetadata()) {
                        ClientAuthInterceptor.this.lastMetadata = ClientAuthInterceptor.this.credentials.getRequestMetadata();
                        ClientAuthInterceptor.this.cached = ClientAuthInterceptor.toHeaders(ClientAuthInterceptor.this.lastMetadata);
                    }
                    cachedSaved = ClientAuthInterceptor.this.cached;
                }
                headers.merge(cachedSaved);
                this.delegate().start(responseListener, headers);
            }
        };
    }

    private static final Metadata.Headers toHeaders(Map<String, List<String>> metadata) {
        Metadata.Headers headers = new Metadata.Headers();
        if (metadata != null) {
            for (String key : metadata.keySet()) {
                Metadata.Key<String> headerKey = Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER);
                for (String value : metadata.get(key)) {
                    headers.put(headerKey, value);
                }
            }
        }
        return headers;
    }
}

