/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;

public class GrpcSslContexts {
    private static ApplicationProtocolConfig DEFAULT_APN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[]{"h2"});

    private GrpcSslContexts() {
    }

    public static SslContextBuilder forClient() {
        return GrpcSslContexts.configure(SslContextBuilder.forClient());
    }

    public static SslContextBuilder forServer(File keyCertChainFile, File keyFile) {
        return GrpcSslContexts.configure(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile));
    }

    public static SslContextBuilder forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        return GrpcSslContexts.configure(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)keyPassword));
    }

    public static SslContextBuilder configure(SslContextBuilder builder) {
        return builder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(DEFAULT_APN);
    }
}

