/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.AbstractServerBuilder;
import io.grpc.HandlerRegistry;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.NettyServer;
import io.grpc.netty.Utils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class NettyServerBuilder
extends AbstractServerBuilder<NettyServerBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private final SocketAddress address;
    private Class<? extends ServerChannel> channelType = NioServerSocketChannel.class;
    private EventLoopGroup userBossEventLoopGroup;
    private EventLoopGroup userWorkerEventLoopGroup;
    private SslContext sslContext;
    private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
    private int flowControlWindow = 0x100000;

    public static NettyServerBuilder forPort(int port) {
        return new NettyServerBuilder(port);
    }

    public static NettyServerBuilder forRegistryAndPort(HandlerRegistry registry, int port) {
        return new NettyServerBuilder(registry, port);
    }

    public static NettyServerBuilder forAddress(SocketAddress address) {
        return new NettyServerBuilder(address);
    }

    private NettyServerBuilder(int port) {
        this.address = new InetSocketAddress(port);
    }

    private NettyServerBuilder(HandlerRegistry registry, int port) {
        super(registry);
        this.address = new InetSocketAddress(port);
    }

    private NettyServerBuilder(SocketAddress address) {
        this.address = address;
    }

    public NettyServerBuilder channelType(Class<? extends ServerChannel> channelType) {
        this.channelType = (Class)Preconditions.checkNotNull(channelType);
        return this;
    }

    public NettyServerBuilder bossEventLoopGroup(EventLoopGroup group) {
        this.userBossEventLoopGroup = group;
        return this;
    }

    public NettyServerBuilder workerEventLoopGroup(EventLoopGroup group) {
        this.userWorkerEventLoopGroup = group;
        return this;
    }

    public NettyServerBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public NettyServerBuilder maxConcurrentCallsPerConnection(int maxCalls) {
        Preconditions.checkArgument((maxCalls > 0 ? 1 : 0) != 0, (String)"max must be positive: %s", (Object[])new Object[]{maxCalls});
        this.maxConcurrentCallsPerConnection = maxCalls;
        return this;
    }

    public NettyServerBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    @Override
    protected AbstractServerBuilder.ServerEssentials buildEssentials() {
        final EventLoopGroup bossEventLoopGroup = this.userBossEventLoopGroup == null ? SharedResourceHolder.get(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP) : this.userBossEventLoopGroup;
        final EventLoopGroup workerEventLoopGroup = this.userWorkerEventLoopGroup == null ? SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP) : this.userWorkerEventLoopGroup;
        NettyServer server = new NettyServer(this.address, this.channelType, bossEventLoopGroup, workerEventLoopGroup, this.sslContext, this.maxConcurrentCallsPerConnection, this.flowControlWindow);
        Runnable terminationRunnable = new Runnable(){

            @Override
            public void run() {
                if (NettyServerBuilder.this.userBossEventLoopGroup == null) {
                    SharedResourceHolder.release(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP, bossEventLoopGroup);
                }
                if (NettyServerBuilder.this.userWorkerEventLoopGroup == null) {
                    SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, workerEventLoopGroup);
                }
            }
        };
        return new AbstractServerBuilder.ServerEssentials(server, terminationRunnable);
    }
}

