/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.netty.JettyAlpnVerifier;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.Utils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.ByteString;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public final class ProtocolNegotiators {
    private ProtocolNegotiators() {
    }

    public static ChannelHandler serverTls(SSLEngine sslEngine) {
        Preconditions.checkNotNull((Object)sslEngine, (Object)"sslEngine");
        if (!(sslEngine instanceof OpenSslEngine)) {
            try {
                JettyAlpnVerifier.verifyJettyAlpn();
            }
            catch (JettyAlpnVerifier.NotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new SslHandler(sslEngine, false);
    }

    public static ProtocolNegotiator tls(final SslContext sslContext, final InetSocketAddress inetAddress) {
        Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        Preconditions.checkNotNull((Object)inetAddress, (Object)"inetAddress");
        if (!(sslContext instanceof OpenSslContext)) {
            try {
                JettyAlpnVerifier.verifyJettyAlpn();
            }
            catch (JettyAlpnVerifier.NotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new ProtocolNegotiator(){

            @Override
            public ProtocolNegotiator.Handler newHandler(Http2ConnectionHandler handler) {
                ChannelHandlerAdapter sslBootstrap = new ChannelHandlerAdapter(){

                    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                        SSLEngine sslEngine = sslContext.newEngine(ctx.alloc(), inetAddress.getHostName(), inetAddress.getPort());
                        SSLParameters sslParams = new SSLParameters();
                        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                        sslEngine.setSSLParameters(sslParams);
                        ctx.pipeline().replace((ChannelHandler)this, null, (ChannelHandler)new SslHandler(sslEngine, false));
                    }
                };
                return new BufferUntilTlsNegotiatedHandler(new ChannelHandler[]{sslBootstrap, handler});
            }
        };
    }

    public static ProtocolNegotiator plaintextUpgrade() {
        return new ProtocolNegotiator(){

            @Override
            public ProtocolNegotiator.Handler newHandler(Http2ConnectionHandler handler) {
                Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(handler);
                HttpClientCodec httpClientCodec = new HttpClientCodec();
                HttpClientUpgradeHandler upgrader = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpClientCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1000);
                return new BufferingHttp2UpgradeHandler(new ChannelHandler[]{upgrader});
            }
        };
    }

    public static ProtocolNegotiator plaintext() {
        return new ProtocolNegotiator(){

            @Override
            public ProtocolNegotiator.Handler newHandler(Http2ConnectionHandler handler) {
                return new BufferUntilChannelActiveHandler(new ChannelHandler[]{handler});
            }
        };
    }

    private static RuntimeException unavailableException(String msg) {
        return Status.UNAVAILABLE.withDescription(msg).asRuntimeException();
    }

    private static class BufferingHttp2UpgradeHandler
    extends AbstractBufferingHandler
    implements ProtocolNegotiator.Handler {
        BufferingHttp2UpgradeHandler(ChannelHandler ... handlers) {
            super(handlers);
        }

        @Override
        public ByteString scheme() {
            return Utils.HTTP;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            DefaultHttpRequest upgradeTrigger = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            ctx.writeAndFlush((Object)upgradeTrigger);
            super.channelActive(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                this.writeBufferedAndRemove(ctx);
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                this.fail(ctx, ProtocolNegotiators.unavailableException("HTTP/2 upgrade rejected"));
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    private static class BufferUntilChannelActiveHandler
    extends AbstractBufferingHandler
    implements ProtocolNegotiator.Handler {
        BufferUntilChannelActiveHandler(ChannelHandler ... handlers) {
            super(handlers);
        }

        @Override
        public ByteString scheme() {
            return Utils.HTTP;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.writeBufferedAndRemove(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.writeBufferedAndRemove(ctx);
            super.channelActive(ctx);
        }
    }

    private static class BufferUntilTlsNegotiatedHandler
    extends AbstractBufferingHandler
    implements ProtocolNegotiator.Handler {
        BufferUntilTlsNegotiatedHandler(ChannelHandler ... handlers) {
            super(handlers);
        }

        @Override
        public ByteString scheme() {
            return Utils.HTTPS;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    this.writeBufferedAndRemove(ctx);
                } else {
                    this.fail(ctx, handshakeEvent.cause());
                }
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    public static abstract class AbstractBufferingHandler
    extends ChannelDuplexHandler {
        private ChannelHandler[] handlers;
        private Queue<ChannelWrite> bufferedWrites = new ArrayDeque<ChannelWrite>();
        private boolean writing;
        private boolean flushRequested;
        private Throwable failCause;

        AbstractBufferingHandler(ChannelHandler ... handlers) {
            this.handlers = handlers;
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            if (this.handlers != null) {
                ctx.pipeline().addFirst(this.handlers);
                this.handlers = null;
            }
            super.channelRegistered(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.fail(ctx, cause);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.fail(ctx, ProtocolNegotiators.unavailableException("Connection broken while performing protocol negotiation"));
            super.channelInactive(ctx);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (this.failCause != null) {
                promise.setFailure(this.failCause);
            } else if (this.bufferedWrites == null) {
                super.write(ctx, msg, promise);
            } else {
                this.bufferedWrites.add(new ChannelWrite(msg, promise));
            }
        }

        public void flush(ChannelHandlerContext ctx) {
            if (this.bufferedWrites == null) {
                ctx.flush();
            } else {
                this.flushRequested = true;
            }
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
            this.fail(ctx, ProtocolNegotiators.unavailableException("Channel closed while performing protocol negotiation"));
        }

        protected final void fail(ChannelHandlerContext ctx, Throwable cause) {
            if (this.failCause == null) {
                this.failCause = cause;
            }
            if (this.bufferedWrites != null) {
                while (!this.bufferedWrites.isEmpty()) {
                    ChannelWrite write = this.bufferedWrites.poll();
                    write.promise.setFailure(cause);
                }
                this.bufferedWrites = null;
            }
            ctx.close();
        }

        protected final void writeBufferedAndRemove(ChannelHandlerContext ctx) {
            if (!ctx.channel().isActive() || this.writing) {
                return;
            }
            this.writing = true;
            while (!this.bufferedWrites.isEmpty()) {
                ChannelWrite write = this.bufferedWrites.poll();
                ctx.write(write.msg, write.promise);
            }
            assert (this.bufferedWrites.isEmpty());
            this.bufferedWrites = null;
            if (this.flushRequested) {
                ctx.flush();
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }

        private static class ChannelWrite {
            Object msg;
            ChannelPromise promise;

            ChannelWrite(Object msg, ChannelPromise promise) {
                this.msg = msg;
                this.promise = promise;
            }
        }
    }
}

