/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.squareup.okhttp.internal.spdy.Header;
import io.grpc.Metadata;
import io.grpc.internal.HttpUtil;
import io.grpc.internal.TransportFrameUtil;
import java.util.ArrayList;
import java.util.List;
import okio.ByteString;

public class Headers {
    public static final Header SCHEME_HEADER = new Header(Header.TARGET_SCHEME, "https");
    public static final Header METHOD_HEADER = new Header(Header.TARGET_METHOD, "POST");
    public static final Header CONTENT_TYPE_HEADER = new Header(HttpUtil.CONTENT_TYPE_KEY.name(), "application/grpc");
    public static final Header TE_HEADER = new Header("te", "trailers");

    public static List<Header> createRequestHeaders(Metadata.Headers headers, String defaultPath, String defaultAuthority) {
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        Preconditions.checkNotNull((Object)defaultPath, (Object)"defaultPath");
        Preconditions.checkNotNull((Object)defaultAuthority, (Object)"defaultAuthority");
        ArrayList<Header> okhttpHeaders = new ArrayList<Header>(6);
        okhttpHeaders.add(SCHEME_HEADER);
        okhttpHeaders.add(METHOD_HEADER);
        String authority = headers.getAuthority() != null ? headers.getAuthority() : defaultAuthority;
        okhttpHeaders.add(new Header(Header.TARGET_AUTHORITY, authority));
        String path = headers.getPath() != null ? headers.getPath() : defaultPath;
        okhttpHeaders.add(new Header(Header.TARGET_PATH, path));
        String userAgent = HttpUtil.getGrpcUserAgent("okhttp", headers.get(HttpUtil.USER_AGENT_KEY));
        okhttpHeaders.add(new Header(HttpUtil.USER_AGENT_KEY.name(), userAgent));
        okhttpHeaders.add(CONTENT_TYPE_HEADER);
        okhttpHeaders.add(TE_HEADER);
        byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers(headers);
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            ByteString key = ByteString.of((byte[])serializedHeaders[i]);
            String keyString = key.utf8();
            if (!Headers.isApplicationHeader(keyString)) continue;
            ByteString value = ByteString.of((byte[])serializedHeaders[i + 1]);
            okhttpHeaders.add(new Header(key, value));
        }
        return okhttpHeaders;
    }

    private static boolean isApplicationHeader(String key) {
        return !key.startsWith(":") && !HttpUtil.CONTENT_TYPE_KEY.name().equalsIgnoreCase(key) && !HttpUtil.USER_AGENT_KEY.name().equalsIgnoreCase(key);
    }
}

