/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.squareup.okhttp.CipherSuite;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.TlsVersion;
import io.grpc.AbstractChannelBuilder;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.okhttp.NegotiationType;
import io.grpc.okhttp.OkHttpClientTransportFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLSocketFactory;

public final class OkHttpChannelBuilder
extends AbstractChannelBuilder<OkHttpChannelBuilder> {
    private static final SharedResourceHolder.Resource<ExecutorService> DEFAULT_TRANSPORT_THREAD_POOL = new SharedResourceHolder.Resource<ExecutorService>(){

        @Override
        public ExecutorService create() {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("grpc-okhttp-%d").build());
        }

        @Override
        public void close(ExecutorService executor) {
            executor.shutdown();
        }
    };
    public static final ConnectionSpec DEFAULT_CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384}).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).supportsTlsExtensions(true).build();
    private ExecutorService transportExecutor;
    private final String host;
    private final int port;
    private String authorityHost;
    private SSLSocketFactory sslSocketFactory;
    private ConnectionSpec connectionSpec = DEFAULT_CONNECTION_SPEC;
    private NegotiationType negotiationType = NegotiationType.TLS;

    public static OkHttpChannelBuilder forAddress(String host, int port) {
        return new OkHttpChannelBuilder(host, port);
    }

    private OkHttpChannelBuilder(String host, int port) {
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.port = port;
        this.authorityHost = host;
    }

    public OkHttpChannelBuilder transportExecutor(ExecutorService executor) {
        this.transportExecutor = executor;
        return this;
    }

    public OkHttpChannelBuilder overrideHostForAuthority(String host) {
        this.authorityHost = host;
        return this;
    }

    public OkHttpChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = (NegotiationType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        return this;
    }

    public OkHttpChannelBuilder sslSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        this.negotiationType(NegotiationType.TLS);
        return this;
    }

    public OkHttpChannelBuilder connectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
        return this;
    }

    @Override
    protected AbstractChannelBuilder.ChannelEssentials buildEssentials() {
        SSLSocketFactory socketFactory;
        final ExecutorService executor = this.transportExecutor == null ? SharedResourceHolder.get(DEFAULT_TRANSPORT_THREAD_POOL) : this.transportExecutor;
        switch (this.negotiationType) {
            case TLS: {
                socketFactory = this.sslSocketFactory == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : this.sslSocketFactory;
                break;
            }
            case PLAINTEXT: {
                socketFactory = null;
                break;
            }
            default: {
                throw new RuntimeException("Unknown negotiation type: " + (Object)((Object)this.negotiationType));
            }
        }
        OkHttpClientTransportFactory transportFactory = new OkHttpClientTransportFactory(this.host, this.port, this.authorityHost, executor, socketFactory, this.connectionSpec);
        Runnable terminationRunnable = null;
        if (this.transportExecutor == null) {
            terminationRunnable = new Runnable(){

                @Override
                public void run() {
                    SharedResourceHolder.release(DEFAULT_TRANSPORT_THREAD_POOL, executor);
                }
            };
        }
        return new AbstractChannelBuilder.ChannelEssentials(transportFactory, terminationRunnable);
    }
}

