/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.squareup.okhttp.ConnectionSpec;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.okhttp.OkHttpClientTransport;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLSocketFactory;

class OkHttpClientTransportFactory
implements ClientTransportFactory {
    private final String host;
    private final int port;
    private final ExecutorService executor;
    private final String authorityHost;
    private final SSLSocketFactory sslSocketFactory;
    private final ConnectionSpec connectionSpec;

    public OkHttpClientTransportFactory(String host, int port, String authorityHost, ExecutorService executor, SSLSocketFactory factory, ConnectionSpec connectionSpec) {
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
        this.port = port;
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.authorityHost = (String)Preconditions.checkNotNull((Object)authorityHost, (Object)"authorityHost");
        this.sslSocketFactory = factory;
        this.connectionSpec = connectionSpec;
    }

    @Override
    public ClientTransport newClientTransport() {
        return new OkHttpClientTransport(this.host, this.port, this.authorityHost, this.executor, this.sslSocketFactory, this.connectionSpec);
    }
}

