/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public class ClientCalls {
    public static <ReqT, RespT> void asyncUnaryCall(ClientCall<ReqT, RespT> call, ReqT param, StreamObserver<RespT> observer) {
        ClientCalls.asyncUnaryRequestCall(call, param, observer, false);
    }

    public static <ReqT, RespT> void asyncServerStreamingCall(ClientCall<ReqT, RespT> call, ReqT param, StreamObserver<RespT> responseObserver) {
        ClientCalls.asyncUnaryRequestCall(call, param, responseObserver, true);
    }

    public static <ReqT, RespT> StreamObserver<ReqT> asyncClientStreamingCall(ClientCall<ReqT, RespT> call, StreamObserver<RespT> responseObserver) {
        return ClientCalls.asyncStreamingRequestCall(call, responseObserver, false);
    }

    public static <ReqT, RespT> StreamObserver<ReqT> asyncBidiStreamingCall(ClientCall<ReqT, RespT> call, StreamObserver<RespT> responseObserver) {
        return ClientCalls.asyncStreamingRequestCall(call, responseObserver, true);
    }

    public static <ReqT, RespT> RespT blockingUnaryCall(ClientCall<ReqT, RespT> call, ReqT param) {
        try {
            return ClientCalls.getUnchecked(ClientCalls.futureUnaryCall(call, param));
        }
        catch (Throwable t) {
            call.cancel();
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static <ReqT, RespT> Iterator<RespT> blockingServerStreamingCall(ClientCall<ReqT, RespT> call, ReqT param) {
        BlockingResponseStream result = new BlockingResponseStream(call);
        ClientCalls.asyncUnaryRequestCall(call, param, result.listener(), true);
        return result;
    }

    public static <ReqT, RespT> ListenableFuture<RespT> futureUnaryCall(ClientCall<ReqT, RespT> call, ReqT param) {
        GrpcFuture<RespT> responseFuture = new GrpcFuture<RespT>(call);
        ClientCalls.asyncUnaryRequestCall(call, param, new UnaryStreamToFuture<RespT>(responseFuture), false);
        return responseFuture;
    }

    private static <V> V getUnchecked(Future<V> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw Status.fromThrowable(e).asRuntimeException();
        }
    }

    private static <ReqT, RespT> void asyncUnaryRequestCall(ClientCall<ReqT, RespT> call, ReqT param, StreamObserver<RespT> responseObserver, boolean streamingResponse) {
        ClientCalls.asyncUnaryRequestCall(call, param, new StreamObserverToCallListenerAdapter<RespT>(call, responseObserver, streamingResponse), streamingResponse);
    }

    private static <ReqT, RespT> void asyncUnaryRequestCall(ClientCall<ReqT, RespT> call, ReqT param, ClientCall.Listener<RespT> responseListener, boolean streamingResponse) {
        ClientCalls.startCall(call, responseListener, streamingResponse);
        try {
            call.sendMessage(param);
            call.halfClose();
        }
        catch (Throwable t) {
            call.cancel();
            throw Throwables.propagate((Throwable)t);
        }
    }

    private static <ReqT, RespT> StreamObserver<ReqT> asyncStreamingRequestCall(ClientCall<ReqT, RespT> call, StreamObserver<RespT> responseObserver, boolean streamingResponse) {
        ClientCalls.startCall(call, new StreamObserverToCallListenerAdapter<RespT>(call, responseObserver, streamingResponse), streamingResponse);
        return new CallToStreamObserverAdapter<ReqT>(call);
    }

    private static <ReqT, RespT> void startCall(ClientCall<ReqT, RespT> call, ClientCall.Listener<RespT> responseListener, boolean streamingResponse) {
        call.start(responseListener, new Metadata.Headers());
        if (streamingResponse) {
            call.request(1);
        } else {
            call.request(2);
        }
    }

    private static class BlockingResponseStream<T>
    implements Iterator<T> {
        private final BlockingQueue<Object> buffer = new ArrayBlockingQueue<Object>(2);
        private final ClientCall.Listener<T> listener = new QueuingListener();
        private final ClientCall<?, T> call;
        private Object last;

        private BlockingResponseStream(ClientCall<?, T> call) {
            this.call = call;
        }

        ClientCall.Listener<T> listener() {
            return this.listener;
        }

        @Override
        public boolean hasNext() {
            try {
                this.last = this.last == null ? this.buffer.take() : this.last;
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                throw new RuntimeException(ie);
            }
            if (this.last instanceof Status) {
                throw ((Status)this.last).asRuntimeException();
            }
            return this.last != this;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object tmp;
                this.call.request(1);
                Object object = tmp = this.last;
                return (T)object;
            }
            finally {
                this.last = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class QueuingListener
        extends ClientCall.Listener<T> {
            private boolean done = false;

            private QueuingListener() {
            }

            @Override
            public void onHeaders(Metadata.Headers headers) {
            }

            @Override
            public void onMessage(T value) {
                Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"ClientCall already closed");
                BlockingResponseStream.this.buffer.add(value);
            }

            @Override
            public void onClose(Status status, Metadata.Trailers trailers) {
                Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"ClientCall already closed");
                if (status.isOk()) {
                    BlockingResponseStream.this.buffer.add(BlockingResponseStream.this);
                } else {
                    BlockingResponseStream.this.buffer.add(status);
                }
                this.done = true;
            }
        }
    }

    private static class GrpcFuture<RespT>
    extends AbstractFuture<RespT> {
        private final ClientCall<?, RespT> call;

        GrpcFuture(ClientCall<?, RespT> call) {
            this.call = call;
        }

        protected void interruptTask() {
            this.call.cancel();
        }

        protected boolean set(@Nullable RespT resp) {
            return super.set(resp);
        }

        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }

    private static class UnaryStreamToFuture<RespT>
    extends ClientCall.Listener<RespT> {
        private final GrpcFuture<RespT> responseFuture;
        private RespT value;

        public UnaryStreamToFuture(GrpcFuture<RespT> responseFuture) {
            this.responseFuture = responseFuture;
        }

        @Override
        public void onHeaders(Metadata.Headers headers) {
        }

        @Override
        public void onMessage(RespT value) {
            if (this.value != null) {
                throw Status.INTERNAL.withDescription("More than one value received for unary call").asRuntimeException();
            }
            this.value = value;
        }

        @Override
        public void onClose(Status status, Metadata.Trailers trailers) {
            if (status.isOk()) {
                if (this.value == null) {
                    this.responseFuture.setException(Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException());
                }
                this.responseFuture.set(this.value);
            } else {
                this.responseFuture.setException(status.asRuntimeException());
            }
        }
    }

    private static class StreamObserverToCallListenerAdapter<RespT>
    extends ClientCall.Listener<RespT> {
        private final ClientCall<?, RespT> call;
        private final StreamObserver<RespT> observer;
        private final boolean streamingResponse;
        private boolean firstResponseReceived;

        public StreamObserverToCallListenerAdapter(ClientCall<?, RespT> call, StreamObserver<RespT> observer, boolean streamingResponse) {
            this.call = call;
            this.observer = observer;
            this.streamingResponse = streamingResponse;
        }

        @Override
        public void onHeaders(Metadata.Headers headers) {
        }

        @Override
        public void onMessage(RespT message) {
            if (this.firstResponseReceived && !this.streamingResponse) {
                throw Status.INTERNAL.withDescription("More than one responses received for unary or client-streaming call").asRuntimeException();
            }
            this.firstResponseReceived = true;
            this.observer.onValue(message);
            if (this.streamingResponse) {
                this.call.request(1);
            }
        }

        @Override
        public void onClose(Status status, Metadata.Trailers trailers) {
            if (status.isOk()) {
                this.observer.onCompleted();
            } else {
                this.observer.onError(status.asRuntimeException());
            }
        }
    }

    private static class CallToStreamObserverAdapter<T>
    implements StreamObserver<T> {
        private final ClientCall<T, ?> call;

        public CallToStreamObserverAdapter(ClientCall<T, ?> call) {
            this.call = call;
        }

        @Override
        public void onValue(T value) {
            this.call.sendMessage(value);
        }

        @Override
        public void onError(Throwable t) {
            this.call.cancel();
        }

        @Override
        public void onCompleted() {
            this.call.halfClose();
        }
    }
}

