/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransportListener;
import io.grpc.netty.CancelServerStreamCommand;
import io.grpc.netty.NettyServerStream;
import io.grpc.netty.RequestMessagesCommand;
import io.grpc.netty.SendGrpcFrameCommand;
import io.grpc.netty.SendResponseHeadersCommand;
import io.grpc.netty.Utils;
import io.grpc.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.ByteString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class NettyServerHandler
extends Http2ConnectionHandler {
    private static Logger logger = Logger.getLogger(NettyServerHandler.class.getName());
    private static final Status GOAWAY_STATUS = Status.UNAVAILABLE;
    private final Http2Connection.PropertyKey streamKey;
    private final ServerTransportListener transportListener;
    private final int maxMessageSize;
    private Throwable connectionError;
    private ChannelHandlerContext ctx;
    private boolean teWarningLogged;
    private int flowControlWindow;
    private Http2Settings initialSettings = new Http2Settings();
    private WriteQueue serverWriteQueue;

    NettyServerHandler(ServerTransportListener transportListener, Http2Connection connection, Http2FrameReader frameReader, Http2FrameWriter frameWriter, int maxStreams, int flowControlWindow, int maxMessageSize) {
        super(connection, frameReader, frameWriter, (Http2FrameListener)new LazyFrameListener());
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        Preconditions.checkArgument((maxMessageSize >= 0 ? 1 : 0) != 0, (Object)"maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        this.streamKey = connection.newKey();
        this.transportListener = (ServerTransportListener)Preconditions.checkNotNull((Object)transportListener, (Object)"transportListener");
        this.initListener();
        this.initialSettings.initialWindowSize(flowControlWindow);
        this.initialSettings.maxConcurrentStreams((long)maxStreams);
    }

    @Nullable
    Throwable connectionError() {
        return this.connectionError;
    }

    private void initListener() {
        ((LazyFrameListener)this.decoder().listener()).setHandler(this);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.serverWriteQueue = new WriteQueue(ctx.channel());
        super.handlerAdded(ctx);
        this.sendInitialSettings();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.sendInitialSettings();
    }

    private void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers) throws Http2Exception {
        if (!this.teWarningLogged && !Utils.TE_TRAILERS.equals(headers.get((Object)Utils.TE_HEADER))) {
            logger.warning(String.format("Expected header TE: %s, but %s is received. This means some intermediate proxy may not support trailers", Utils.TE_TRAILERS, headers.get((Object)Utils.TE_HEADER)));
            this.teWarningLogged = true;
        }
        try {
            this.verifyContentType(streamId, headers);
            String method = this.determineMethod(streamId, headers);
            Http2Stream http2Stream = this.requireHttp2Stream(streamId);
            NettyServerStream stream = new NettyServerStream(ctx.channel(), http2Stream, this, this.maxMessageSize);
            Metadata metadata = Utils.convertHeaders(headers);
            ServerStreamListener listener = this.transportListener.streamCreated(stream, method, metadata);
            stream.setListener(listener);
            http2Stream.setProperty(this.streamKey, (Object)stream);
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onHeadersRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onDataRead(int streamId, ByteBuf data, boolean endOfStream) throws Http2Exception {
        try {
            NettyServerStream stream = this.serverStream(this.requireHttp2Stream(streamId));
            stream.inboundDataReceived(data, endOfStream);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onDataRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onRstStreamRead(int streamId) throws Http2Exception {
        try {
            NettyServerStream stream = this.serverStream(this.requireHttp2Stream(streamId));
            stream.abortStream(Status.CANCELLED, false);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onRstStreamRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        logger.log(Level.WARNING, "Connection Error", cause);
        this.connectionError = cause;
        super.onConnectionError(ctx, cause, http2Ex);
    }

    protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
        NettyServerStream serverStream;
        logger.log(Level.WARNING, "Stream Error", cause);
        Http2Stream stream = this.connection().stream(Http2Exception.streamId((Http2Exception)http2Ex));
        NettyServerStream nettyServerStream = serverStream = stream != null ? this.serverStream(stream) : null;
        if (serverStream != null) {
            serverStream.abortStream(cause instanceof Http2Exception ? Status.INTERNAL.withCause(cause) : Status.fromThrowable(cause), true);
        } else {
            super.onStreamError(ctx, cause, http2Ex);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                public boolean visit(Http2Stream stream) throws Http2Exception {
                    NettyServerHandler.this.serverStream(stream).abortStream(GOAWAY_STATUS, false);
                    return true;
                }
            });
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    WriteQueue getWriteQueue() {
        return this.serverWriteQueue;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Http2Exception {
        if (msg instanceof SendGrpcFrameCommand) {
            this.sendGrpcFrame(ctx, (SendGrpcFrameCommand)((Object)msg), promise);
        } else if (msg instanceof SendResponseHeadersCommand) {
            this.sendResponseHeaders(ctx, (SendResponseHeadersCommand)msg, promise);
        } else if (msg instanceof RequestMessagesCommand) {
            ((RequestMessagesCommand)msg).requestMessages();
        } else if (msg instanceof CancelServerStreamCommand) {
            this.cancelStream(ctx, (CancelServerStreamCommand)msg, promise);
        } else {
            AssertionError e = new AssertionError((Object)("Write called for unexpected type: " + msg.getClass().getName()));
            ReferenceCountUtil.release((Object)msg);
            promise.setFailure((Throwable)((Object)e));
            throw e;
        }
    }

    void returnProcessedBytes(Http2Stream http2Stream, int bytes) {
        try {
            this.decoder().flowController().consumeBytes(http2Stream, bytes);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void closeStreamWhenDone(ChannelPromise promise, int streamId) throws Http2Exception {
        final NettyServerStream stream = this.serverStream(this.requireHttp2Stream(streamId));
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                stream.complete();
            }
        });
    }

    private void sendGrpcFrame(ChannelHandlerContext ctx, SendGrpcFrameCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeData(ctx, cmd.streamId(), cmd.content(), 0, cmd.endStream(), promise);
    }

    private void sendResponseHeaders(ChannelHandlerContext ctx, SendResponseHeadersCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endOfStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeHeaders(ctx, cmd.streamId(), cmd.headers(), 0, cmd.endOfStream(), promise);
    }

    private void cancelStream(ChannelHandlerContext ctx, CancelServerStreamCommand cmd, ChannelPromise promise) {
        cmd.stream().abortStream(cmd.reason(), false);
        this.encoder().writeRstStream(ctx, cmd.stream().id().intValue(), Http2Error.CANCEL.code(), promise);
    }

    private void verifyContentType(int streamId, Http2Headers headers) throws Http2Exception {
        ByteString contentType = (ByteString)headers.get((Object)Utils.CONTENT_TYPE_HEADER);
        if (contentType == null) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Content-Type is missing from the request", (Object[])new Object[0]);
        }
        String contentTypeString = contentType.toString(Charsets.US_ASCII);
        if (!GrpcUtil.isGrpcContentType(contentTypeString)) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Content-Type '%s' is not supported", (Object[])new Object[]{contentTypeString});
        }
    }

    private Http2Stream requireHttp2Stream(int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            throw new AssertionError((Object)("Stream does not exist: " + streamId));
        }
        return stream;
    }

    private String determineMethod(int streamId, Http2Headers headers) throws Http2Exception {
        if (!Utils.HTTP_METHOD.equals((Object)headers.method())) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Method '%s' is not supported", (Object[])new Object[]{headers.method()});
        }
        NettyServerHandler.checkHeader(streamId, headers, Utils.CONTENT_TYPE_HEADER, Utils.CONTENT_TYPE_GRPC);
        ByteString path = headers.path();
        if (path.byteAt(0) != 47) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Malformatted path: %s", (Object[])new Object[]{path});
        }
        return path.toString(1, path.length());
    }

    private static void checkHeader(int streamId, Http2Headers headers, ByteString header, ByteString expectedValue) throws Http2Exception {
        if (!expectedValue.equals(headers.get((Object)header))) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Header '%s'='%s', while '%s' is expected", (Object[])new Object[]{header, headers.get((Object)header), expectedValue});
        }
    }

    private NettyServerStream serverStream(Http2Stream stream) {
        return (NettyServerStream)stream.getProperty(this.streamKey);
    }

    private Http2Exception newStreamException(int streamId, Throwable cause) {
        return Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)cause, (String)cause.getMessage(), (Object[])new Object[0]);
    }

    private void sendInitialSettings() throws Http2Exception {
        if (!this.ctx.channel().isActive()) {
            return;
        }
        boolean needToFlush = false;
        if (this.initialSettings != null) {
            needToFlush = true;
            this.encoder().writeSettings(this.ctx, this.initialSettings, this.ctx.newPromise());
            this.initialSettings = null;
        }
        if (this.flowControlWindow > 0) {
            needToFlush = true;
            Http2Stream connectionStream = this.connection().connectionStream();
            int currentSize = ((Http2LocalFlowController)this.connection().local().flowController()).windowSize(connectionStream);
            int delta = this.flowControlWindow - currentSize;
            this.decoder().flowController().incrementWindowSize(connectionStream, delta);
            this.flowControlWindow = -1;
        }
        if (needToFlush) {
            this.ctx.flush();
        }
    }

    private static class LazyFrameListener
    extends Http2FrameAdapter {
        private NettyServerHandler handler;

        private LazyFrameListener() {
        }

        void setHandler(NettyServerHandler handler) {
            this.handler = handler;
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            this.handler.onDataRead(streamId, data, endOfStream);
            return padding;
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            this.handler.onHeadersRead(ctx, streamId, headers);
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            this.handler.onRstStreamRead(streamId);
        }
    }
}

