/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractServerStream;
import io.grpc.internal.WritableBuffer;
import io.grpc.netty.CancelServerStreamCommand;
import io.grpc.netty.NettyReadableBuffer;
import io.grpc.netty.NettyServerHandler;
import io.grpc.netty.NettyWritableBuffer;
import io.grpc.netty.NettyWritableBufferAllocator;
import io.grpc.netty.RequestMessagesCommand;
import io.grpc.netty.SendGrpcFrameCommand;
import io.grpc.netty.SendResponseHeadersCommand;
import io.grpc.netty.Utils;
import io.grpc.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;

class NettyServerStream
extends AbstractServerStream<Integer> {
    private final Channel channel;
    private final NettyServerHandler handler;
    private final Http2Stream http2Stream;
    private final WriteQueue writeQueue;

    NettyServerStream(Channel channel, Http2Stream http2Stream, NettyServerHandler handler, int maxMessageSize) {
        super(new NettyWritableBufferAllocator(channel.alloc()), maxMessageSize);
        this.writeQueue = handler.getWriteQueue();
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.http2Stream = (Http2Stream)Preconditions.checkNotNull((Object)http2Stream, (Object)"http2Stream");
        this.handler = (NettyServerHandler)((Object)Preconditions.checkNotNull((Object)((Object)handler), (Object)"handler"));
    }

    @Override
    public Integer id() {
        return this.http2Stream.id();
    }

    void inboundDataReceived(ByteBuf frame, boolean endOfStream) {
        super.inboundDataReceived(new NettyReadableBuffer(frame.retain()), endOfStream);
    }

    @Override
    public void request(int numMessages) {
        if (this.channel.eventLoop().inEventLoop()) {
            this.requestMessagesFromDeframer(numMessages);
        } else {
            this.writeQueue.enqueue(new RequestMessagesCommand(this, numMessages), true);
        }
    }

    @Override
    protected void inboundDeliveryPaused() {
    }

    @Override
    protected void internalSendHeaders(Metadata headers) {
        this.writeQueue.enqueue(new SendResponseHeadersCommand(this.id(), Utils.convertServerHeaders(headers), false), true);
    }

    @Override
    protected void sendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf();
        final int numBytes = bytebuf.readableBytes();
        this.onSendingBytes(numBytes);
        this.writeQueue.enqueue((Object)new SendGrpcFrameCommand(this, bytebuf, endOfStream), this.channel.newPromise().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerStream.this.onSentBytes(numBytes);
            }
        }), flush);
    }

    @Override
    protected void sendTrailers(Metadata trailers, boolean headersSent) {
        Http2Headers http2Trailers = Utils.convertTrailers(trailers, headersSent);
        this.writeQueue.enqueue(new SendResponseHeadersCommand(this.id(), http2Trailers, true), true);
    }

    @Override
    protected void returnProcessedBytes(int processedBytes) {
        this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
        this.writeQueue.scheduleFlush();
    }

    @Override
    public void cancel(Status status) {
        this.writeQueue.enqueue(new CancelServerStreamCommand(this, status), true);
    }

    void useDecompressor(String messageEncoding) {
        this.setDecompressor(messageEncoding);
    }
}

